/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.LibraryChunk;
import apk.arsc.PackageChunk;
import apk.arsc.ResourceTableChunk;
import apk.arsc.SerializableResource;
import apk.arsc.StringPoolChunk;
import apk.arsc.TypeChunk;
import apk.arsc.TypeSpecChunk;
import apk.arsc.UnknownChunk;
import apk.arsc.XmlCdataChunk;
import apk.arsc.XmlChunk;
import apk.arsc.XmlEndElementChunk;
import apk.arsc.XmlNamespaceEndChunk;
import apk.arsc.XmlNamespaceStartChunk;
import apk.arsc.XmlResourceMapChunk;
import apk.arsc.XmlStartElementChunk;
import apk.base.Preconditions;
import apk.io.LittleEndianDataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class Chunk
implements SerializableResource {
    public static final int PAD_BOUNDARY = 4;
    public static final int METADATA_SIZE = 8;
    public static final int METADATA_SIZE_NO_TYPE = 6;
    private static final int CHUNK_SIZE_OFFSET = 4;
    @Nullable
    private final Chunk parent;
    protected final int headerSize;
    protected final int chunkSize;
    protected final int offset;

    protected Chunk(ByteBuffer buffer, @Nullable Chunk parent) {
        this.parent = parent;
        this.offset = buffer.position() - 2;
        this.headerSize = buffer.getShort() & 0xFFFF;
        this.chunkSize = buffer.getInt();
    }

    protected void init(ByteBuffer buffer) {
    }

    @Nullable
    public Chunk getParent() {
        return this.parent;
    }

    protected abstract Type getType();

    public final int getHeaderSize() {
        return this.headerSize;
    }

    public final int getOriginalChunkSize() {
        return this.chunkSize;
    }

    protected final void seekToEndOfChunk(ByteBuffer buffer) {
        buffer.position(this.offset + this.chunkSize);
    }

    protected final void writeHeader(ByteBuffer output, int chunkSize) {
        int start = output.position();
        output.putShort(this.getTypeValue());
        output.putShort((short)this.headerSize);
        output.putInt(chunkSize);
        this.writeHeader(output);
        int headerBytes = output.position() - start;
        Preconditions.checkState(headerBytes == this.getHeaderSize(), "Written header is wrong size. Got %s, want %s", headerBytes, this.getHeaderSize());
    }

    protected short getTypeValue() {
        return this.getType().code();
    }

    protected void writeHeader(ByteBuffer output) {
    }

    protected void writePayload(DataOutput output, ByteBuffer header, int options) throws IOException {
    }

    protected static int writePad(DataOutput output, int currentLength) throws IOException {
        while (currentLength % 4 != 0) {
            output.write(0);
            ++currentLength;
        }
        return currentLength;
    }

    @Override
    public final byte[] toByteArray() throws IOException {
        return this.toByteArray(0);
    }

    @Override
    public final byte[] toByteArray(int options) throws IOException {
        ByteBuffer header = ByteBuffer.allocate(this.getHeaderSize()).order(ByteOrder.LITTLE_ENDIAN);
        this.writeHeader(header, 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (LittleEndianDataOutputStream payload = new LittleEndianDataOutputStream(baos);){
            this.writePayload(payload, header, options);
        }
        byte[] payloadBytes = baos.toByteArray();
        int chunkSize = this.getHeaderSize() + payloadBytes.length;
        header.putInt(4, chunkSize);
        ByteBuffer result = ByteBuffer.allocate(chunkSize).order(ByteOrder.LITTLE_ENDIAN);
        result.put(header.array());
        result.put(payloadBytes);
        return result.array();
    }

    public static Chunk newInstance(ByteBuffer buffer) {
        return Chunk.newInstance(buffer, null);
    }

    public static Chunk newInstance(ByteBuffer buffer, @Nullable Chunk parent) {
        Chunk result;
        Type type = Type.fromCode(buffer.getShort());
        switch (type) {
            case STRING_POOL: {
                result = new StringPoolChunk(buffer, parent);
                break;
            }
            case TABLE: {
                result = new ResourceTableChunk(buffer, parent);
                break;
            }
            case XML: {
                result = new XmlChunk(buffer, parent);
                break;
            }
            case XML_START_NAMESPACE: {
                result = new XmlNamespaceStartChunk(buffer, parent);
                break;
            }
            case XML_END_NAMESPACE: {
                result = new XmlNamespaceEndChunk(buffer, parent);
                break;
            }
            case XML_START_ELEMENT: {
                result = new XmlStartElementChunk(buffer, parent);
                break;
            }
            case XML_END_ELEMENT: {
                result = new XmlEndElementChunk(buffer, parent);
                break;
            }
            case XML_CDATA: {
                result = new XmlCdataChunk(buffer, parent);
                break;
            }
            case XML_RESOURCE_MAP: {
                result = new XmlResourceMapChunk(buffer, parent);
                break;
            }
            case TABLE_PACKAGE: {
                result = new PackageChunk(buffer, parent);
                break;
            }
            case TABLE_TYPE: {
                result = new TypeChunk(buffer, parent);
                break;
            }
            case TABLE_TYPE_SPEC: {
                result = new TypeSpecChunk(buffer, parent);
                break;
            }
            case TABLE_LIBRARY: {
                result = new LibraryChunk(buffer, parent);
                break;
            }
            default: {
                result = new UnknownChunk(buffer, parent);
            }
        }
        result.init(buffer);
        result.seekToEndOfChunk(buffer);
        return result;
    }

    public static enum Type {
        NULL(0),
        STRING_POOL(1),
        TABLE(2),
        XML(3),
        XML_START_NAMESPACE(256),
        XML_END_NAMESPACE(257),
        XML_START_ELEMENT(258),
        XML_END_ELEMENT(259),
        XML_CDATA(260),
        XML_RESOURCE_MAP(384),
        TABLE_PACKAGE(512),
        TABLE_TYPE(513),
        TABLE_TYPE_SPEC(514),
        TABLE_LIBRARY(515),
        TABLE_OVERLAYABLE(516),
        TABLE_OVERLAYABLE_POLICY(517);

        private final short code;
        private static final Map<Short, Type> FROM_SHORT;

        private Type(int code) {
            this.code = (short)code;
        }

        public short code() {
            return this.code;
        }

        public static Type fromCode(short code) {
            Type type = FROM_SHORT.get(code);
            if (type == null) {
                throw new NullPointerException("Unknown chunk type: " + code);
            }
            return type;
        }

        static {
            HashMap<Short, Type> map = new HashMap<Short, Type>();
            for (Type type : Type.values()) {
                map.put(type.code(), type);
            }
            FROM_SHORT = Collections.unmodifiableMap(map);
        }
    }
}

