/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.Chunk;
import apk.base.Preconditions;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ChunkWithChunks
extends Chunk {
    protected final Map<Integer, Chunk> chunks = new LinkedHashMap<Integer, Chunk>();

    protected ChunkWithChunks(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
    }

    @Override
    protected void init(ByteBuffer buffer) {
        Chunk chunk;
        int start;
        super.init(buffer);
        this.chunks.clear();
        int end = this.offset + this.getOriginalChunkSize();
        int position = buffer.position();
        buffer.position(start);
        for (int offset = start = this.offset + this.getHeaderSize(); offset < end; offset += chunk.getOriginalChunkSize()) {
            chunk = this.createChildInstance(buffer);
            this.chunks.put(offset, chunk);
        }
        buffer.position(position);
    }

    protected Chunk createChildInstance(ByteBuffer buffer) {
        return Chunk.newInstance(buffer, this);
    }

    public final Map<Integer, Chunk> getChunks() {
        return this.chunks;
    }

    protected void remove(Chunk chunk) {
        Chunk deleted = this.chunks.remove(chunk.offset);
        if (chunk != deleted) {
            throw new IllegalStateException(String.format("Can't remove %s.", chunk.getClass()));
        }
    }

    protected void add(Chunk chunk) {
        int offset = 0;
        if (this.chunks.size() > 0) {
            int oldMax = Collections.max(this.chunks.keySet());
            Chunk oldChunk = Preconditions.checkNotNull(this.chunks.get(oldMax));
            offset = oldMax + oldChunk.getOriginalChunkSize();
        }
        this.chunks.put(offset, chunk);
        Preconditions.checkArgument(chunk.getParent() == this);
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, int options) throws IOException {
        for (Chunk chunk : this.getChunks().values()) {
            byte[] chunkBytes = chunk.toByteArray(options);
            output.write(chunkBytes);
            ChunkWithChunks.writePad(output, chunkBytes.length);
        }
    }
}

