/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.Chunk;
import apk.arsc.ChunkWithChunks;
import apk.arsc.LibraryChunk;
import apk.arsc.PackageUtils;
import apk.arsc.StringPoolChunk;
import apk.arsc.TypeChunk;
import apk.arsc.TypeSpecChunk;
import apk.arsc.UnknownChunk;
import apk.base.Preconditions;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class PackageChunk
extends ChunkWithChunks {
    protected static final int TYPE_OFFSET_OFFSET = 268;
    protected static final int KEY_OFFSET_OFFSET = 276;
    protected static final int HEADER_SIZE = 288;
    private int id;
    private String packageName;
    protected final int typeStringsOffset;
    private final int lastPublicType;
    protected final int keyStringsOffset;
    private final int lastPublicKey;
    private final int typeIdOffset;
    private final Map<Integer, TypeSpecChunk> typeSpecs = new HashMap<Integer, TypeSpecChunk>();
    private final Map<Integer, Set<TypeChunk>> types = new HashMap<Integer, Set<TypeChunk>>();
    private LibraryChunk libraryChunk = null;

    protected PackageChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.id = buffer.getInt();
        this.packageName = PackageUtils.readPackageName(buffer, buffer.position());
        this.typeStringsOffset = buffer.getInt();
        this.lastPublicType = buffer.getInt();
        this.keyStringsOffset = buffer.getInt();
        this.lastPublicKey = buffer.getInt();
        this.typeIdOffset = buffer.getInt();
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        this.initializeChildMappings();
    }

    protected void reinitializeChildMappings() {
        this.types.clear();
        this.typeSpecs.clear();
        this.libraryChunk = null;
        this.initializeChildMappings();
    }

    private void initializeChildMappings() {
        for (Chunk chunk : this.getChunks().values()) {
            if (chunk instanceof TypeChunk) {
                TypeChunk typeChunk = (TypeChunk)chunk;
                this.putIntoTypes(typeChunk);
                continue;
            }
            if (chunk instanceof TypeSpecChunk) {
                TypeSpecChunk typeSpecChunk = (TypeSpecChunk)chunk;
                this.typeSpecs.put(typeSpecChunk.getId(), typeSpecChunk);
                continue;
            }
            if (chunk instanceof LibraryChunk) {
                if (this.libraryChunk != null) {
                    throw new IllegalStateException("Multiple library chunks present in package chunk.");
                }
                this.libraryChunk = (LibraryChunk)chunk;
                continue;
            }
            if (chunk instanceof StringPoolChunk || chunk instanceof UnknownChunk) continue;
            throw new IllegalStateException(String.format("PackageChunk contains an unexpected chunk: %s", chunk.getClass()));
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id2) {
        this.id = id2;
    }

    public StringPoolChunk getKeyStringPool() {
        Chunk chunk = Preconditions.checkNotNull(this.getChunks().get(this.keyStringsOffset + this.offset));
        Preconditions.checkState(chunk instanceof StringPoolChunk, "Key string pool not found.");
        return (StringPoolChunk)chunk;
    }

    public String getTypeString(int id2) {
        StringPoolChunk typePool = this.getTypeStringPool();
        Preconditions.checkNotNull(typePool, "Package has no type pool.");
        Preconditions.checkState(typePool.strings.size() >= id2, "No type for id: " + id2);
        return typePool.getString(id2 - 1);
    }

    public StringPoolChunk getTypeStringPool() {
        Chunk chunk = Preconditions.checkNotNull(this.getChunks().get(this.typeStringsOffset + this.offset));
        Preconditions.checkState(chunk instanceof StringPoolChunk, "Type string pool not found.");
        return (StringPoolChunk)chunk;
    }

    public Collection<TypeChunk> getTypeChunks() {
        LinkedHashSet<TypeChunk> typeChunks = new LinkedHashSet<TypeChunk>();
        for (Collection collection : this.types.values()) {
            typeChunks.addAll(collection);
        }
        return typeChunks;
    }

    public Collection<TypeChunk> getTypeChunks(int id2) {
        Set<TypeChunk> chunks = this.types.get(id2);
        return chunks != null ? chunks : Collections.emptySet();
    }

    public Collection<TypeChunk> getTypeChunks(String type) {
        StringPoolChunk typeStringPool = Preconditions.checkNotNull(this.getTypeStringPool());
        return this.getTypeChunks(typeStringPool.indexOf(type) + 1);
    }

    public Collection<TypeSpecChunk> getTypeSpecChunks() {
        return this.typeSpecs.values();
    }

    public TypeSpecChunk getTypeSpecChunk(int id2) {
        return Preconditions.checkNotNull(this.typeSpecs.get(id2));
    }

    public TypeSpecChunk getTypeSpecChunk(String type) {
        StringPoolChunk typeStringPool = Preconditions.checkNotNull(this.getTypeStringPool());
        return this.getTypeSpecChunk(typeStringPool.indexOf(type) + 1);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void remove(TypeChunk chunk) {
        super.remove(chunk);
        int chunkId = chunk.getId();
        if (!this.removeFromTypes(chunk)) {
            throw new IllegalStateException(String.format("Can't remove %s from packageChunk.", chunk.getClass()));
        }
        if (!this.types.containsKey(chunkId)) {
            TypeSpecChunk specChunk = this.typeSpecs.remove(chunkId);
            Preconditions.checkNotNull(specChunk, "Typespec chunk not found for id: " + chunkId);
            super.remove(specChunk);
        }
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.TABLE_PACKAGE;
    }

    public int deleteKeyStrings(SortedSet<Integer> keyIndexesToDelete) {
        int[] remappedIndexes = this.getKeyStringPool().deleteStrings(keyIndexesToDelete);
        ArrayList<TypeChunk> typeChunksToDelete = new ArrayList<TypeChunk>();
        for (TypeChunk typeChunk : this.getTypeChunks()) {
            boolean shouldDeleteTypeChunk = true;
            TreeMap<Integer, TypeChunk.Entry> replacementEntries = new TreeMap<Integer, TypeChunk.Entry>();
            for (Map.Entry<Integer, TypeChunk.Entry> entry : typeChunk.getEntries().entrySet()) {
                int newIndex = remappedIndexes[entry.getValue().keyIndex()];
                shouldDeleteTypeChunk = shouldDeleteTypeChunk && newIndex == -1;
                replacementEntries.put(entry.getKey(), newIndex == -1 ? null : entry.getValue().withKeyIndex(newIndex));
            }
            typeChunk.overrideEntries(replacementEntries);
            if (!shouldDeleteTypeChunk) continue;
            typeChunksToDelete.add(typeChunk);
        }
        for (TypeChunk typeChunk : typeChunksToDelete) {
            this.remove(typeChunk);
        }
        return typeChunksToDelete.size();
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        output.putInt(this.id);
        PackageUtils.writePackageName(output, this.packageName);
        output.putInt(0);
        output.putInt(this.lastPublicType);
        output.putInt(0);
        output.putInt(this.lastPublicKey);
        output.putInt(this.typeIdOffset);
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, int options) throws IOException {
        int typeOffset = this.typeStringsOffset;
        int keyOffset = this.keyStringsOffset;
        int payloadOffset = 0;
        for (Chunk chunk : this.getChunks().values()) {
            if (chunk == this.getTypeStringPool()) {
                typeOffset = payloadOffset + this.getHeaderSize();
            } else if (chunk == this.getKeyStringPool()) {
                keyOffset = payloadOffset + this.getHeaderSize();
            }
            byte[] chunkBytes = chunk.toByteArray(options);
            output.write(chunkBytes);
            payloadOffset = PackageChunk.writePad(output, chunkBytes.length);
        }
        header.putInt(268, typeOffset);
        header.putInt(276, keyOffset);
    }

    private void putIntoTypes(TypeChunk typeChunk) {
        Set<TypeChunk> chunks = this.types.get(typeChunk.getId());
        if (chunks == null) {
            chunks = new LinkedHashSet<TypeChunk>();
            this.types.put(typeChunk.getId(), chunks);
        }
        chunks.add(typeChunk);
    }

    private boolean removeFromTypes(TypeChunk typeChunk) {
        int chunkId = typeChunk.getId();
        Set<TypeChunk> chunks = this.types.get(chunkId);
        if (chunks == null || !chunks.remove(typeChunk)) {
            return false;
        }
        if (chunks.isEmpty()) {
            this.types.remove(chunkId);
        }
        return true;
    }
}

