/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public final class PackageUtils {
    public static final int PACKAGE_NAME_SIZE = 256;

    private PackageUtils() {
    }

    public static String readPackageName(ByteBuffer buffer, int offset) {
        byte[] data = buffer.array();
        int length = 0;
        for (int i11 = offset; i11 < data.length && i11 < 256 + offset; i11 += 2) {
            if (data[i11] != 0 || data[i11 + 1] != 0) continue;
            length = i11 - offset;
            break;
        }
        Charset utf16 = Charset.forName("UTF-16LE");
        String str = new String(data, offset, length, utf16);
        buffer.position(offset + 256);
        return str;
    }

    public static void writePackageName(ByteBuffer buffer, String packageName) {
        byte[] nameBytes = packageName.getBytes(Charset.forName("UTF-16LE"));
        buffer.put(nameBytes, 0, Math.min(nameBytes.length, 256));
        if (nameBytes.length < 256) {
            buffer.put(new byte[256 - nameBytes.length]);
        }
    }
}

