/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.AutoValue_ResourceConfiguration;
import apk.arsc.SerializableResource;
import apk.base.Bytes;
import apk.base.Charsets;
import apk.base.Preconditions;
import com.google.auto.value.AutoValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

@AutoValue
public abstract class ResourceConfiguration
implements SerializableResource {
    private static final Builder DEFAULT_BUILDER = ResourceConfiguration.builder();
    public static final ResourceConfiguration DEFAULT = DEFAULT_BUILDER.build();
    static final int COLOR_MODE_WIDE_COLOR_GAMUT_MASK = 3;
    static final int COLOR_MODE_WIDE_COLOR_GAMUT_UNDEFINED = 0;
    static final int COLOR_MODE_WIDE_COLOR_GAMUT_NO = 1;
    static final int COLOR_MODE_WIDE_COLOR_GAMUT_YES = 2;
    private static final Map<Integer, String> COLOR_MODE_WIDE_COLOR_GAMUT_VALUES;
    static final int COLOR_MODE_HDR_MASK = 12;
    static final int COLOR_MODE_HDR_UNDEFINED = 0;
    static final int COLOR_MODE_HDR_NO = 4;
    static final int COLOR_MODE_HDR_YES = 8;
    private static final Map<Integer, String> COLOR_MODE_HDR_VALUES;
    static final int DENSITY_DPI_UNDEFINED = 0;
    static final int DENSITY_DPI_LDPI = 120;
    static final int DENSITY_DPI_MDPI = 160;
    static final int DENSITY_DPI_TVDPI = 213;
    static final int DENSITY_DPI_HDPI = 240;
    static final int DENSITY_DPI_XHDPI = 320;
    static final int DENSITY_DPI_XXHDPI = 480;
    static final int DENSITY_DPI_XXXHDPI = 640;
    static final int DENSITY_DPI_ANY = 65534;
    static final int DENSITY_DPI_NONE = 65535;
    private static final Map<Integer, String> DENSITY_DPI_VALUES;
    static final int KEYBOARD_NOKEYS = 1;
    static final int KEYBOARD_QWERTY = 2;
    static final int KEYBOARD_12KEY = 3;
    private static final Map<Integer, String> KEYBOARD_VALUES;
    static final int KEYBOARDHIDDEN_MASK = 3;
    static final int KEYBOARDHIDDEN_NO = 1;
    static final int KEYBOARDHIDDEN_YES = 2;
    static final int KEYBOARDHIDDEN_SOFT = 3;
    private static final Map<Integer, String> KEYBOARDHIDDEN_VALUES;
    static final int NAVIGATION_NONAV = 1;
    static final int NAVIGATION_DPAD = 2;
    static final int NAVIGATION_TRACKBALL = 3;
    static final int NAVIGATION_WHEEL = 4;
    private static final Map<Integer, String> NAVIGATION_VALUES;
    static final int NAVIGATIONHIDDEN_MASK = 12;
    static final int NAVIGATIONHIDDEN_NO = 4;
    static final int NAVIGATIONHIDDEN_YES = 8;
    private static final Map<Integer, String> NAVIGATIONHIDDEN_VALUES;
    static final int ORIENTATION_PORTRAIT = 1;
    static final int ORIENTATION_LANDSCAPE = 2;
    private static final Map<Integer, String> ORIENTATION_VALUES;
    static final int SCREENLAYOUT_LAYOUTDIR_MASK = 192;
    static final int SCREENLAYOUT_LAYOUTDIR_LTR = 64;
    static final int SCREENLAYOUT_LAYOUTDIR_RTL = 128;
    private static final Map<Integer, String> SCREENLAYOUT_LAYOUTDIR_VALUES;
    static final int SCREENLAYOUT_LONG_MASK = 48;
    static final int SCREENLAYOUT_LONG_NO = 16;
    static final int SCREENLAYOUT_LONG_YES = 32;
    private static final Map<Integer, String> SCREENLAYOUT_LONG_VALUES;
    static final int SCREENLAYOUT_ROUND_MASK = 3;
    static final int SCREENLAYOUT_ROUND_NO = 1;
    static final int SCREENLAYOUT_ROUND_YES = 2;
    private static final Map<Integer, String> SCREENLAYOUT_ROUND_VALUES;
    static final int SCREENLAYOUT_SIZE_MASK = 15;
    static final int SCREENLAYOUT_SIZE_SMALL = 1;
    static final int SCREENLAYOUT_SIZE_NORMAL = 2;
    static final int SCREENLAYOUT_SIZE_LARGE = 3;
    static final int SCREENLAYOUT_SIZE_XLARGE = 4;
    private static final Map<Integer, String> SCREENLAYOUT_SIZE_VALUES;
    static final int TOUCHSCREEN_NOTOUCH = 1;
    static final int TOUCHSCREEN_FINGER = 3;
    private static final Map<Integer, String> TOUCHSCREEN_VALUES;
    static final int UI_MODE_NIGHT_MASK = 48;
    static final int UI_MODE_NIGHT_NO = 16;
    static final int UI_MODE_NIGHT_YES = 32;
    private static final Map<Integer, String> UI_MODE_NIGHT_VALUES;
    static final int UI_MODE_TYPE_MASK = 15;
    static final int UI_MODE_TYPE_DESK = 2;
    static final int UI_MODE_TYPE_CAR = 3;
    static final int UI_MODE_TYPE_TELEVISION = 4;
    static final int UI_MODE_TYPE_APPLIANCE = 5;
    static final int UI_MODE_TYPE_WATCH = 6;
    static final int UI_MODE_TYPE_VR_HEADSET = 7;
    private static final Map<Integer, String> UI_MODE_TYPE_VALUES;
    private static final int MIN_SIZE = 28;
    private static final int SCREEN_CONFIG_MIN_SIZE = 32;
    private static final int SCREEN_DP_MIN_SIZE = 36;
    private static final int LOCALE_MIN_SIZE = 48;
    private static final int SCREEN_CONFIG_EXTENSION_MIN_SIZE = 52;
    public static final int SIZE = 52;

    public abstract int size();

    public abstract int mcc();

    public abstract int mnc();

    public abstract byte[] language();

    public final String languageString() {
        return this.unpackLanguage();
    }

    public abstract byte[] region();

    public final String regionString() {
        return this.unpackRegion();
    }

    public abstract int orientation();

    public abstract int touchscreen();

    public abstract int density();

    public abstract int keyboard();

    public abstract int navigation();

    public abstract int inputFlags();

    public final int keyboardHidden() {
        return this.inputFlags() & 3;
    }

    public final int navigationHidden() {
        return this.inputFlags() & 0xC;
    }

    public abstract int screenWidth();

    public abstract int screenHeight();

    public abstract int sdkVersion();

    public final ResourceConfiguration withSdkVersion(int sdkVersion) {
        return this.toBuilder().sdkVersion(sdkVersion).build();
    }

    public abstract int minorVersion();

    public abstract int screenLayout();

    public final int screenLayoutDirection() {
        return this.screenLayout() & 0xC0;
    }

    public final int screenLayoutSize() {
        return this.screenLayout() & 0xF;
    }

    public final int screenLayoutLong() {
        return this.screenLayout() & 0x30;
    }

    public final int screenLayoutRound() {
        return this.screenLayout2() & 3;
    }

    public abstract int uiMode();

    public final int uiModeType() {
        return this.uiMode() & 0xF;
    }

    public final int uiModeNight() {
        return this.uiMode() & 0x30;
    }

    public abstract int smallestScreenWidthDp();

    public abstract int screenWidthDp();

    public abstract int screenHeightDp();

    public abstract byte[] localeScript();

    public final String localeScriptString() {
        return this.byteArrayToString(this.localeScript());
    }

    public abstract byte[] localeVariant();

    public final String localeVariantString() {
        return this.byteArrayToString(this.localeVariant());
    }

    public abstract int screenLayout2();

    public abstract int colorMode();

    public final int colorModeWideColorGamut() {
        return this.colorMode() & 3;
    }

    public final int colorModeHdr() {
        return this.colorMode() & 0xC;
    }

    public abstract byte[] unknown();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_ResourceConfiguration.Builder().size(52).mcc(0).mnc(0).language(new byte[2]).region(new byte[2]).orientation(0).touchscreen(0).density(0).keyboard(0).navigation(0).inputFlags(0).screenWidth(0).screenHeight(0).sdkVersion(0).minorVersion(0).screenLayout(0).uiMode(0).smallestScreenWidthDp(0).screenWidthDp(0).screenHeightDp(0).localeScript(new byte[4]).localeVariant(new byte[8]).screenLayout2(0).colorMode(0).unknown(new byte[0]);
    }

    static ResourceConfiguration create(ByteBuffer buffer) {
        int startPosition = buffer.position();
        int size = buffer.getInt();
        Preconditions.checkArgument(size >= 28, "Expected minimum ResourceConfiguration size of %s, got %s", 28, size);
        Builder configurationBuilder = ResourceConfiguration.builder().size(size).mcc(buffer.getShort() & 0xFFFF).mnc(buffer.getShort() & 0xFFFF);
        byte[] language = new byte[2];
        buffer.get(language);
        byte[] region = new byte[2];
        buffer.get(region);
        configurationBuilder.language(language).region(region).orientation(buffer.get() & 0xFF).touchscreen(buffer.get() & 0xFF).density(buffer.getShort() & 0xFFFF).keyboard(buffer.get() & 0xFF).navigation(buffer.get() & 0xFF).inputFlags(buffer.get() & 0xFF);
        buffer.get();
        configurationBuilder.screenWidth(buffer.getShort() & 0xFFFF).screenHeight(buffer.getShort() & 0xFFFF).sdkVersion(buffer.getShort() & 0xFFFF).minorVersion(buffer.getShort() & 0xFFFF);
        if (size >= 32) {
            configurationBuilder.screenLayout(buffer.get() & 0xFF).uiMode(buffer.get() & 0xFF).smallestScreenWidthDp(buffer.getShort() & 0xFFFF);
        }
        if (size >= 36) {
            configurationBuilder.screenWidthDp(buffer.getShort() & 0xFFFF).screenHeightDp(buffer.getShort() & 0xFFFF);
        }
        if (size >= 48) {
            byte[] localeScript = new byte[4];
            buffer.get(localeScript);
            byte[] localeVariant = new byte[8];
            buffer.get(localeVariant);
            configurationBuilder.localeScript(localeScript).localeVariant(localeVariant);
        }
        if (size >= 52) {
            configurationBuilder.screenLayout2(buffer.get() & 0xFF);
            configurationBuilder.colorMode(buffer.get() & 0xFF);
            buffer.getShort();
        }
        int bytesRead = buffer.position() - startPosition;
        byte[] unknown = new byte[size - bytesRead];
        buffer.get(unknown);
        configurationBuilder.unknown(unknown);
        return configurationBuilder.build();
    }

    private String unpackLanguage() {
        return ResourceConfiguration.unpackLanguage(this.language());
    }

    public static String unpackLanguage(byte[] language) {
        return ResourceConfiguration.unpackLanguageOrRegion(language, 97);
    }

    private String unpackRegion() {
        return ResourceConfiguration.unpackLanguageOrRegion(this.region(), 48);
    }

    private static String unpackLanguageOrRegion(byte[] value, int base) {
        Preconditions.checkState(value.length == 2, "Language or region value must be 2 bytes.");
        if (value[0] == 0 && value[1] == 0) {
            return "";
        }
        if ((value[0] & 0x80) != 0) {
            byte[] result = new byte[]{(byte)(base + (value[1] & 0x1F)), (byte)(base + ((value[1] & 0xE0) >>> 5) + ((value[0] & 3) << 3)), (byte)(base + ((value[0] & 0x7C) >>> 2))};
            return new String(result, Charsets.US_ASCII);
        }
        return new String(value, Charsets.US_ASCII);
    }

    public static byte[] packLanguage(String language) {
        byte[] unpacked = language.getBytes(Charsets.US_ASCII);
        if (unpacked.length == 2) {
            return unpacked;
        }
        int base = 97;
        byte[] result = new byte[2];
        Preconditions.checkState(unpacked.length == 3);
        for (byte value : unpacked) {
            Preconditions.checkState(value >= 97 && value <= 122);
        }
        result[0] = (byte)(unpacked[2] - base << 2 | unpacked[1] - base >> 3 | 0x80);
        result[1] = (byte)(unpacked[0] - base | unpacked[1] - base << 5);
        return result;
    }

    private String byteArrayToString(byte[] data) {
        int length = Bytes.indexOf(data, (byte)0);
        return new String(data, 0, length >= 0 ? length : data.length, Charsets.US_ASCII);
    }

    public final boolean isDefault() {
        return DEFAULT_BUILDER.size(this.size()).unknown(this.unknown()).build().equals(this) && Arrays.equals(this.unknown(), new byte[this.unknown().length]);
    }

    public final boolean isDensityCompatibleWith(int deviceDensityDpi) {
        int configDensity = this.density();
        switch (configDensity) {
            case 0: 
            case 65534: 
            case 65535: {
                return true;
            }
        }
        return configDensity <= deviceDensityDpi;
    }

    @Override
    public final byte[] toByteArray() {
        return this.toByteArray(0);
    }

    @Override
    public final byte[] toByteArray(int options) {
        ByteBuffer buffer = ByteBuffer.allocate(this.size()).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.size());
        buffer.putShort((short)this.mcc());
        buffer.putShort((short)this.mnc());
        buffer.put(this.language());
        buffer.put(this.region());
        buffer.put((byte)this.orientation());
        buffer.put((byte)this.touchscreen());
        buffer.putShort((short)this.density());
        buffer.put((byte)this.keyboard());
        buffer.put((byte)this.navigation());
        buffer.put((byte)this.inputFlags());
        buffer.put((byte)0);
        buffer.putShort((short)this.screenWidth());
        buffer.putShort((short)this.screenHeight());
        buffer.putShort((short)this.sdkVersion());
        buffer.putShort((short)this.minorVersion());
        if (this.size() >= 32) {
            buffer.put((byte)this.screenLayout());
            buffer.put((byte)this.uiMode());
            buffer.putShort((short)this.smallestScreenWidthDp());
        }
        if (this.size() >= 36) {
            buffer.putShort((short)this.screenWidthDp());
            buffer.putShort((short)this.screenHeightDp());
        }
        if (this.size() >= 48) {
            buffer.put(this.localeScript());
            buffer.put(this.localeVariant());
        }
        if (this.size() >= 52) {
            buffer.put((byte)this.screenLayout2());
            buffer.put((byte)this.colorMode());
            buffer.putShort((short)0);
        }
        buffer.put(this.unknown());
        return buffer.array();
    }

    public final String toString() {
        if (this.isDefault()) {
            return "default";
        }
        Map<Type, String> parts = this.toStringParts();
        this.mergeLocale(parts);
        Collection<String> values = parts.values();
        values.removeAll(Collections.singleton(""));
        return ResourceConfiguration.join(values, '-');
    }

    private static String join(Collection<String> values, char sep) {
        StringBuilder sb2 = new StringBuilder();
        Iterator<String> iterator = values.iterator();
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            String next = iterator.next();
            sb2.append(next);
            hasNext = iterator.hasNext();
            if (!hasNext) continue;
            sb2.append(sep);
        }
        return sb2.toString();
    }

    private void mergeLocale(Map<Type, String> parts) {
        String region;
        String script = this.localeScriptString();
        String variant = this.localeVariantString();
        if (script.isEmpty() && variant.isEmpty()) {
            return;
        }
        StringBuilder locale = new StringBuilder("b+").append(this.languageString());
        if (!script.isEmpty()) {
            locale.append("+" + script);
        }
        if (!(region = this.regionString()).isEmpty()) {
            locale.append("+" + region);
        }
        if (!variant.isEmpty()) {
            locale.append("+" + variant);
        }
        parts.put(Type.LANGUAGE_STRING, locale.toString());
        parts.remove((Object)Type.LOCALE_SCRIPT_STRING);
        parts.remove((Object)Type.REGION_STRING);
        parts.remove((Object)Type.LOCALE_VARIANT_STRING);
    }

    public final Map<Type, String> toStringParts() {
        LinkedHashMap<Type, String> result = new LinkedHashMap<Type, String>();
        result.put(Type.MCC, this.mcc() != 0 ? "mcc" + this.mcc() : "");
        result.put(Type.MNC, this.mnc() != 0 ? "mnc" + this.mnc() : "");
        result.put(Type.LANGUAGE_STRING, this.languageString());
        result.put(Type.LOCALE_SCRIPT_STRING, this.localeScriptString());
        result.put(Type.REGION_STRING, !this.regionString().isEmpty() ? "r" + this.regionString() : "");
        result.put(Type.LOCALE_VARIANT_STRING, this.localeVariantString());
        result.put(Type.SCREEN_LAYOUT_DIRECTION, this.getOrDefault(SCREENLAYOUT_LAYOUTDIR_VALUES, this.screenLayoutDirection(), ""));
        result.put(Type.SMALLEST_SCREEN_WIDTH_DP, this.smallestScreenWidthDp() != 0 ? "sw" + this.smallestScreenWidthDp() + "dp" : "");
        result.put(Type.SCREEN_WIDTH_DP, this.screenWidthDp() != 0 ? "w" + this.screenWidthDp() + "dp" : "");
        result.put(Type.SCREEN_HEIGHT_DP, this.screenHeightDp() != 0 ? "h" + this.screenHeightDp() + "dp" : "");
        result.put(Type.SCREEN_LAYOUT_SIZE, this.getOrDefault(SCREENLAYOUT_SIZE_VALUES, this.screenLayoutSize(), ""));
        result.put(Type.SCREEN_LAYOUT_LONG, this.getOrDefault(SCREENLAYOUT_LONG_VALUES, this.screenLayoutLong(), ""));
        result.put(Type.SCREEN_LAYOUT_ROUND, this.getOrDefault(SCREENLAYOUT_ROUND_VALUES, this.screenLayoutRound(), ""));
        result.put(Type.COLOR_MODE_HDR, this.getOrDefault(COLOR_MODE_HDR_VALUES, this.colorModeHdr(), ""));
        result.put(Type.COLOR_MODE_WIDE_COLOR_GAMUT, this.getOrDefault(COLOR_MODE_WIDE_COLOR_GAMUT_VALUES, this.colorModeWideColorGamut(), ""));
        result.put(Type.ORIENTATION, this.getOrDefault(ORIENTATION_VALUES, this.orientation(), ""));
        result.put(Type.UI_MODE_TYPE, this.getOrDefault(UI_MODE_TYPE_VALUES, this.uiModeType(), ""));
        result.put(Type.UI_MODE_NIGHT, this.getOrDefault(UI_MODE_NIGHT_VALUES, this.uiModeNight(), ""));
        result.put(Type.DENSITY_DPI, this.getOrDefault(DENSITY_DPI_VALUES, this.density(), this.density() + "dpi"));
        result.put(Type.TOUCHSCREEN, this.getOrDefault(TOUCHSCREEN_VALUES, this.touchscreen(), ""));
        result.put(Type.KEYBOARD_HIDDEN, this.getOrDefault(KEYBOARDHIDDEN_VALUES, this.keyboardHidden(), ""));
        result.put(Type.KEYBOARD, this.getOrDefault(KEYBOARD_VALUES, this.keyboard(), ""));
        result.put(Type.NAVIGATION_HIDDEN, this.getOrDefault(NAVIGATIONHIDDEN_VALUES, this.navigationHidden(), ""));
        result.put(Type.NAVIGATION, this.getOrDefault(NAVIGATION_VALUES, this.navigation(), ""));
        result.put(Type.SCREEN_SIZE, this.screenWidth() != 0 || this.screenHeight() != 0 ? this.screenWidth() + "x" + this.screenHeight() : "");
        String sdkVersion = "";
        if (this.sdkVersion() != 0) {
            sdkVersion = "v" + this.sdkVersion();
            if (this.minorVersion() != 0) {
                sdkVersion = sdkVersion + "." + this.minorVersion();
            }
        }
        result.put(Type.SDK_VERSION, sdkVersion);
        return result;
    }

    private <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
        V value = map.get(key);
        return value != null ? value : defaultValue;
    }

    static {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "");
        map.put(1, "nowidecg");
        map.put(2, "widecg");
        COLOR_MODE_WIDE_COLOR_GAMUT_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(0, "");
        map.put(4, "lowdr");
        map.put(8, "highdr");
        COLOR_MODE_HDR_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(0, "");
        map.put(120, "ldpi");
        map.put(160, "mdpi");
        map.put(213, "tvdpi");
        map.put(240, "hdpi");
        map.put(320, "xhdpi");
        map.put(480, "xxhdpi");
        map.put(640, "xxxhdpi");
        map.put(65534, "anydpi");
        map.put(65535, "nodpi");
        DENSITY_DPI_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(1, "nokeys");
        map.put(2, "qwerty");
        map.put(3, "12key");
        KEYBOARD_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(1, "keysexposed");
        map.put(2, "keyshidden");
        map.put(3, "keyssoft");
        KEYBOARDHIDDEN_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(1, "nonav");
        map.put(2, "dpad");
        map.put(3, "trackball");
        map.put(4, "wheel");
        NAVIGATION_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(4, "navexposed");
        map.put(8, "navhidden");
        NAVIGATIONHIDDEN_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(1, "port");
        map.put(2, "land");
        ORIENTATION_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(64, "ldltr");
        map.put(128, "ldrtl");
        SCREENLAYOUT_LAYOUTDIR_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(16, "notlong");
        map.put(32, "long");
        SCREENLAYOUT_LONG_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(1, "notround");
        map.put(2, "round");
        SCREENLAYOUT_ROUND_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(1, "small");
        map.put(2, "normal");
        map.put(3, "large");
        map.put(4, "xlarge");
        SCREENLAYOUT_SIZE_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(1, "notouch");
        map.put(3, "finger");
        TOUCHSCREEN_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(16, "notnight");
        map.put(32, "night");
        UI_MODE_NIGHT_VALUES = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(2, "desk");
        map.put(3, "car");
        map.put(4, "television");
        map.put(5, "appliance");
        map.put(6, "watch");
        map.put(7, "vrheadset");
        UI_MODE_TYPE_VALUES = Collections.unmodifiableMap(map);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder size(int var1);

        public abstract Builder mcc(int var1);

        public abstract Builder mnc(int var1);

        public abstract Builder language(byte[] var1);

        public abstract Builder region(byte[] var1);

        public abstract Builder orientation(int var1);

        public abstract Builder touchscreen(int var1);

        public abstract Builder density(int var1);

        public abstract Builder keyboard(int var1);

        public abstract Builder navigation(int var1);

        public abstract Builder inputFlags(int var1);

        public abstract Builder screenWidth(int var1);

        public abstract Builder screenHeight(int var1);

        public abstract Builder sdkVersion(int var1);

        public abstract Builder minorVersion(int var1);

        public abstract Builder screenLayout(int var1);

        public abstract Builder uiMode(int var1);

        public abstract Builder smallestScreenWidthDp(int var1);

        public abstract Builder screenWidthDp(int var1);

        public abstract Builder screenHeightDp(int var1);

        public abstract Builder localeScript(byte[] var1);

        public abstract Builder localeVariant(byte[] var1);

        public abstract Builder screenLayout2(int var1);

        public abstract Builder colorMode(int var1);

        abstract Builder unknown(byte[] var1);

        public abstract ResourceConfiguration build();
    }

    public static enum Type {
        MCC,
        MNC,
        LANGUAGE_STRING,
        LOCALE_SCRIPT_STRING,
        REGION_STRING,
        LOCALE_VARIANT_STRING,
        SCREEN_LAYOUT_DIRECTION,
        SMALLEST_SCREEN_WIDTH_DP,
        SCREEN_WIDTH_DP,
        SCREEN_HEIGHT_DP,
        SCREEN_LAYOUT_SIZE,
        SCREEN_LAYOUT_LONG,
        SCREEN_LAYOUT_ROUND,
        COLOR_MODE_WIDE_COLOR_GAMUT,
        COLOR_MODE_HDR,
        ORIENTATION,
        UI_MODE_TYPE,
        UI_MODE_NIGHT,
        DENSITY_DPI,
        TOUCHSCREEN,
        KEYBOARD_HIDDEN,
        KEYBOARD,
        NAVIGATION_HIDDEN,
        NAVIGATION,
        SCREEN_SIZE,
        SDK_VERSION;

    }
}

