/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.Chunk;
import apk.arsc.SerializableResource;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ResourceFile
implements SerializableResource {
    private final List<Chunk> chunks = new ArrayList<Chunk>();

    public ResourceFile(ByteBuffer buf) {
        buf.order(ByteOrder.LITTLE_ENDIAN);
        while (buf.remaining() > 0) {
            this.chunks.add(Chunk.newInstance(buf));
        }
    }

    public ResourceFile(byte[] buf) {
        this(ByteBuffer.wrap(buf));
    }

    public List<Chunk> getChunks() {
        return Collections.unmodifiableList(this.chunks);
    }

    @Override
    public byte[] toByteArray() throws IOException {
        return this.toByteArray(0);
    }

    @Override
    public byte[] toByteArray(int options) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        for (Chunk chunk : this.chunks) {
            output.write(chunk.toByteArray(options));
        }
        return baos.toByteArray();
    }
}

