/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.AutoValue_ResourceIdentifier;
import apk.base.Preconditions;
import com.google.auto.value.AutoValue;

@AutoValue
public abstract class ResourceIdentifier {
    private static final int PACKAGE_ID_MASK = -16777216;
    private static final int PACKAGE_ID_SHIFT = 24;
    private static final int TYPE_ID_MASK = 0xFF0000;
    private static final int TYPE_ID_SHIFT = 16;
    private static final int ENTRY_ID_MASK = 65535;
    private static final int ENTRY_ID_SHIFT = 0;

    public abstract int packageId();

    public abstract int typeId();

    public abstract int entryId();

    public static ResourceIdentifier create(int resourceId) {
        int packageId = (resourceId & 0xFF000000) >>> 24;
        int typeId = (resourceId & 0xFF0000) >>> 16;
        int entryId = (resourceId & 0xFFFF) >>> 0;
        return ResourceIdentifier.create(packageId, typeId, entryId);
    }

    public static ResourceIdentifier create(int packageId, int typeId, int entryId) {
        Preconditions.checkState((packageId & 0xFF) == packageId, "packageId must be <= 0xFF.");
        Preconditions.checkState((typeId & 0xFF) == typeId, "typeId must be <= 0xFF.");
        Preconditions.checkState((entryId & 0xFFFF) == entryId, "entryId must be <= 0xFFFF.");
        return new AutoValue_ResourceIdentifier(packageId, typeId, entryId);
    }

    public static int entryIdFromResourceId(int resourceId) {
        return resourceId & 0xFFFF;
    }

    public static int asInt(int packageId, int typeId, int entryId) {
        Preconditions.checkState((packageId & 0xFF) == packageId, "packageId must be <= 0xFF.");
        Preconditions.checkState((typeId & 0xFF) == typeId, "typeId must be <= 0xFF.");
        Preconditions.checkState((entryId & 0xFFFF) == entryId, "entryId must be <= 0xFFFF.");
        return packageId << 24 | typeId << 16 | entryId;
    }
}

