/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.UtfUtil;
import apk.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public final class ResourceString {
    private ResourceString() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decodeString(ByteBuffer buffer, int offset, Type type) {
        int characterCount = ResourceString.decodeLength(buffer, offset, type);
        offset += ResourceString.computeLengthOffset(characterCount, type);
        if (type == Type.UTF8) {
            int length = ResourceString.decodeLength(buffer, offset, type);
            int origPosition = buffer.position();
            buffer.position(offset += ResourceString.computeLengthOffset(length, type));
            try {
                char[] chars = UtfUtil.decodeUtf8OrModifiedUtf8(buffer, characterCount);
                String string = new String(chars);
                return string;
            }
            finally {
                buffer.position(origPosition);
            }
        }
        int length = characterCount * 2;
        return new String(buffer.array(), offset, length, type.charset());
    }

    public static byte[] encodeString(String str, Type type) {
        byte[] bytes = str.getBytes(type.charset());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length + 5);
        try {
            DataOutputStream output = new DataOutputStream(baos);
            ResourceString.encodeLength(output, str.length(), type);
            if (type == Type.UTF8) {
                ResourceString.encodeLength(output, bytes.length, type);
            }
            output.write(bytes);
            if (type == Type.UTF8) {
                output.write(0);
            } else {
                output.writeShort(0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    private static void encodeLength(DataOutput output, int length, Type type) throws IOException {
        if (length < 0) {
            output.write(0);
            return;
        }
        if (type == Type.UTF8) {
            if (length > 127) {
                output.write((length & 0x7F00) >> 8 | 0x80);
            }
            output.write(length & 0xFF);
        } else {
            if (length > Short.MAX_VALUE) {
                int highBytes = (length & 0x7FFF0000) >> 16 | 0x8000;
                output.write(highBytes & 0xFF);
                output.write((highBytes & 0xFF00) >> 8);
            }
            int lowBytes = length & 0xFFFF;
            output.write(lowBytes & 0xFF);
            output.write((lowBytes & 0xFF00) >> 8);
        }
    }

    private static int computeLengthOffset(int length, Type type) {
        return (type == Type.UTF8 ? 1 : 2) * (length >= (type == Type.UTF8 ? 128 : 32768) ? 2 : 1);
    }

    private static int decodeLength(ByteBuffer buffer, int offset, Type type) {
        return type == Type.UTF8 ? ResourceString.decodeLengthUTF8(buffer, offset) : ResourceString.decodeLengthUTF16(buffer, offset);
    }

    private static int decodeLengthUTF8(ByteBuffer buffer, int offset) {
        int length = buffer.get(offset) & 0xFF;
        if ((length & 0x80) != 0) {
            length = (length & 0x7F) << 8 | buffer.get(offset + 1) & 0xFF;
        }
        return length;
    }

    private static int decodeLengthUTF16(ByteBuffer buffer, int offset) {
        int length = buffer.getShort(offset) & 0xFFFF;
        if ((length & 0x8000) != 0) {
            length = (length & Short.MAX_VALUE) << 16 | buffer.getShort(offset + 2) & 0xFFFF;
        }
        return length;
    }

    public static enum Type {
        UTF8(Charsets.UTF_8),
        UTF16(Charsets.UTF_16LE);

        private final Charset charset;

        private Type(Charset charset) {
            this.charset = charset;
        }

        public Charset charset() {
            return this.charset;
        }
    }
}

