/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.Chunk;
import apk.arsc.ChunkWithChunks;
import apk.arsc.PackageChunk;
import apk.arsc.ResourceValue;
import apk.arsc.StringPoolChunk;
import apk.arsc.TypeChunk;
import apk.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class ResourceTableChunk
extends ChunkWithChunks {
    private StringPoolChunk stringPool;
    protected static final int HEADER_SIZE = 12;
    private final Map<String, PackageChunk> packages = new HashMap<String, PackageChunk>();

    protected ResourceTableChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        Preconditions.checkState(buffer.getInt() >= 1, "ResourceTableChunk package count was < 1.");
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        this.setChildChunks();
    }

    protected void setChildChunks() {
        this.packages.clear();
        for (Chunk chunk : this.getChunks().values()) {
            if (chunk instanceof PackageChunk) {
                PackageChunk packageChunk = (PackageChunk)chunk;
                this.packages.put(packageChunk.getPackageName(), packageChunk);
                continue;
            }
            if (!(chunk instanceof StringPoolChunk)) continue;
            this.stringPool = (StringPoolChunk)chunk;
        }
        Preconditions.checkNotNull(this.stringPool, "ResourceTableChunk must have a string pool.");
    }

    public StringPoolChunk getStringPool() {
        return this.stringPool;
    }

    public void addPackageChunk(PackageChunk packageChunk) {
        super.add(packageChunk);
        this.packages.put(packageChunk.getPackageName(), packageChunk);
    }

    public void deleteStrings(SortedSet<Integer> indexesToDelete) {
        int[] remappedIndexes = this.stringPool.deleteStrings(indexesToDelete);
        for (PackageChunk packageChunk : this.getPackages()) {
            for (TypeChunk typeChunk : packageChunk.getTypeChunks()) {
                TreeMap<Integer, TypeChunk.Entry> replacementEntries = new TreeMap<Integer, TypeChunk.Entry>();
                for (Map.Entry<Integer, TypeChunk.Entry> entry : typeChunk.getEntries().entrySet()) {
                    Integer index = entry.getKey();
                    TypeChunk.Entry chunkEntry = entry.getValue();
                    if (chunkEntry.isComplex()) {
                        TreeMap<Integer, ResourceValue> newValues = new TreeMap<Integer, ResourceValue>();
                        for (Map.Entry<Integer, ResourceValue> valuesEntry : chunkEntry.values().entrySet()) {
                            Integer key = valuesEntry.getKey();
                            ResourceValue value = valuesEntry.getValue();
                            if (ResourceTableChunk.isString(value)) {
                                int newIndex = remappedIndexes[value.data()];
                                Preconditions.checkArgument(newIndex >= 0);
                                value = value.withData(newIndex);
                            }
                            newValues.put(key, value);
                        }
                        replacementEntries.put(index, chunkEntry.withValues(newValues));
                        continue;
                    }
                    ResourceValue value = Preconditions.checkNotNull(chunkEntry.value());
                    if (!ResourceTableChunk.isString(value)) continue;
                    int newIndex = remappedIndexes[value.data()];
                    replacementEntries.put(index, newIndex == -1 ? null : chunkEntry.withValue(value.withData(newIndex)));
                }
                typeChunk.overrideEntries(replacementEntries);
            }
        }
    }

    private static boolean isString(ResourceValue value) {
        return value.type() == ResourceValue.Type.STRING;
    }

    @Nullable
    public PackageChunk getPackage(String packageName) {
        return this.packages.get(packageName);
    }

    @Nullable
    public PackageChunk getPackage(int packageId) {
        for (PackageChunk chunk : this.packages.values()) {
            if (chunk.getId() != packageId) continue;
            return chunk;
        }
        return null;
    }

    public Collection<PackageChunk> getPackages() {
        return Collections.unmodifiableCollection(this.packages.values());
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.TABLE;
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        super.writeHeader(output);
        output.putInt(this.packages.size());
    }
}

