/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.AutoValue_ResourceValue;
import apk.arsc.SerializableResource;
import apk.base.Preconditions;
import com.google.auto.value.AutoValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AutoValue
public abstract class ResourceValue
implements SerializableResource {
    public static final int SIZE = 8;

    public abstract int size();

    public abstract Type type();

    public abstract int data();

    public static Builder builder() {
        return new AutoValue_ResourceValue.Builder();
    }

    abstract Builder toBuilder();

    ResourceValue withData(int d11) {
        return this.toBuilder().data(d11).build();
    }

    public static ResourceValue create(ByteBuffer buffer) {
        int size = buffer.getShort() & 0xFFFF;
        buffer.get();
        Type type = Type.fromCode(buffer.get());
        int data = buffer.getInt();
        return ResourceValue.builder().size(size).type(type).data(data).build();
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(0);
    }

    @Override
    public byte[] toByteArray(int options) {
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putShort((short)this.size());
        buffer.put((byte)0);
        buffer.put(this.type().code());
        buffer.putInt(this.data());
        return buffer.array();
    }

    private String dataHexString() {
        return String.format("0x%08x", this.data());
    }

    public String toString() {
        switch (this.type()) {
            case NULL: {
                return this.data() == 0 ? "null" : "empty";
            }
            case REFERENCE: {
                return "ref(" + this.dataHexString() + ")";
            }
            case ATTRIBUTE: {
                return "attr(" + this.dataHexString() + ")";
            }
            case STRING: {
                return "string(" + this.dataHexString() + ")";
            }
            case FLOAT: {
                return "float(" + this.data() + ")";
            }
            case DIMENSION: {
                return "dimen(" + this.data() + ")";
            }
            case FRACTION: {
                return "frac(" + this.data() + ")";
            }
            case DYNAMIC_REFERENCE: {
                return "dynref(" + this.dataHexString() + ")";
            }
            case DYNAMIC_ATTRIBUTE: {
                return "dynattr(" + this.dataHexString() + ")";
            }
            case INT_DEC: {
                return "dec(" + this.data() + ")";
            }
            case INT_HEX: {
                return "hex(" + this.dataHexString() + ")";
            }
            case INT_BOOLEAN: {
                return "bool(" + this.data() + ")";
            }
            case INT_COLOR_ARGB8: {
                return "argb8(" + this.dataHexString() + ")";
            }
            case INT_COLOR_RGB8: {
                return "rgb8(" + this.dataHexString() + ")";
            }
            case INT_COLOR_ARGB4: {
                return "argb4(" + this.dataHexString() + ")";
            }
            case INT_COLOR_RGB4: {
                return "rgb4(" + this.dataHexString() + ")";
            }
        }
        return "<invalid value>";
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder size(int var1);

        public abstract Builder type(Type var1);

        public abstract Builder data(int var1);

        public abstract ResourceValue build();
    }

    public static enum Type {
        NULL(0),
        REFERENCE(1),
        ATTRIBUTE(2),
        STRING(3),
        FLOAT(4),
        DIMENSION(5),
        FRACTION(6),
        DYNAMIC_REFERENCE(7),
        DYNAMIC_ATTRIBUTE(8),
        INT_DEC(16),
        INT_HEX(17),
        INT_BOOLEAN(18),
        INT_COLOR_ARGB8(28),
        INT_COLOR_RGB8(29),
        INT_COLOR_ARGB4(30),
        INT_COLOR_RGB4(31);

        private final byte code;
        private static final Map<Byte, Type> FROM_BYTE;

        private Type(int code) {
            this.code = (byte)code;
        }

        public byte code() {
            return this.code;
        }

        public static Type fromCode(byte code) {
            return Preconditions.checkNotNull(FROM_BYTE.get(code), "Unknown resource type: %s", code);
        }

        static {
            HashMap<Byte, Type> map = new HashMap<Byte, Type>();
            for (Type type : Type.values()) {
                map.put(type.code(), type);
            }
            FROM_BYTE = Collections.unmodifiableMap(map);
        }
    }
}

