/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.AutoValue_StringPoolChunk_StringPoolSpan;
import apk.arsc.AutoValue_StringPoolChunk_StringPoolStyle;
import apk.arsc.Chunk;
import apk.arsc.ResourceString;
import apk.arsc.SerializableResource;
import apk.base.Preconditions;
import apk.io.LittleEndianDataOutputStream;
import com.google.auto.value.AutoValue;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;

public class StringPoolChunk
extends Chunk {
    private static final int SORTED_FLAG = 1;
    private static final int UTF8_FLAG = 256;
    private static final int STYLE_START_OFFSET = 24;
    private final int flags;
    private final int stringsStart;
    private final int stylesStart;
    protected final int stringCount;
    protected final int styleCount;
    protected List<String> strings = new ArrayList<String>();
    protected List<StringPoolStyle> styles = new ArrayList<StringPoolStyle>();
    protected boolean alwaysDedup = false;

    protected StringPoolChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.stringCount = buffer.getInt();
        this.styleCount = buffer.getInt();
        this.flags = buffer.getInt();
        this.stringsStart = buffer.getInt();
        this.stylesStart = buffer.getInt();
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        this.strings.addAll(this.readStrings(buffer, this.offset + this.stringsStart, this.stringCount));
        this.styles.addAll(this.readStyles(buffer, this.offset + this.stylesStart, this.styleCount));
    }

    public int indexOf(String string) {
        return this.strings.indexOf(string);
    }

    public String getString(int index) {
        return this.strings.get(index);
    }

    public void setString(int index, String value) {
        this.strings.set(index, value);
    }

    public int addString(String value) {
        this.strings.add(value);
        return this.strings.size() - 1;
    }

    public int getStringCount() {
        return this.strings.size();
    }

    private void removeIndexesOfStringsWithNameIndexReferencesOutstanding(Set<Integer> indexesToDelete) {
        HashSet<Integer> indexesToSave = new HashSet<Integer>();
        for (int i11 = 0; i11 < this.styles.size(); ++i11) {
            if (indexesToDelete.contains(i11)) continue;
            StringPoolStyle style = this.styles.get(i11);
            for (StringPoolSpan span : style.spans()) {
                if (!indexesToDelete.contains(span.nameIndex())) continue;
                indexesToSave.add(span.nameIndex());
            }
        }
        indexesToDelete.removeAll(indexesToSave);
    }

    protected static List<StringPoolStyle> fixUpStyles(List<StringPoolStyle> styles, int[] remappedIndexes) {
        ArrayList<StringPoolStyle> result = new ArrayList<StringPoolStyle>(styles.size());
        for (StringPoolStyle style : styles) {
            ArrayList<StringPoolSpan> newSpans = new ArrayList<StringPoolSpan>(style.spans().size());
            for (StringPoolSpan span : style.spans()) {
                int newIndex = remappedIndexes[span.nameIndex()];
                Preconditions.checkArgument(newIndex >= 0);
                newSpans.add(span.withNameIndex(newIndex));
            }
            result.add(StringPoolStyle.create(Collections.unmodifiableList(newSpans)));
        }
        return result;
    }

    public int[] deleteStrings(SortedSet<Integer> indexesToDelete) {
        int previousStringCount = this.strings.size();
        int previousStyleCount = this.styles.size();
        this.removeIndexesOfStringsWithNameIndexReferencesOutstanding(indexesToDelete);
        int[] result = new int[previousStringCount];
        int resultIndex = -1;
        int offset = 0;
        ArrayList<String> newStrings = new ArrayList<String>();
        ArrayList<StringPoolStyle> newStyles = new ArrayList<StringPoolStyle>();
        Iterator iterator = indexesToDelete.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            for (int i11 = resultIndex + 1; i11 < index; ++i11) {
                result[i11] = i11 - offset;
                newStrings.add(this.strings.get(i11));
                if (i11 >= previousStyleCount) continue;
                newStyles.add(this.styles.get(i11));
            }
            result[index] = -1;
            ++offset;
            resultIndex = index;
        }
        for (int i12 = resultIndex + 1; i12 < previousStringCount; ++i12) {
            result[i12] = i12 - offset;
            newStrings.add(this.strings.get(i12));
            if (i12 >= previousStyleCount) continue;
            newStyles.add(this.styles.get(i12));
        }
        this.strings = newStrings;
        this.styles = StringPoolChunk.fixUpStyles(newStyles, result);
        return result;
    }

    public StringPoolStyle getStyle(int index) {
        return this.styles.get(index);
    }

    public int getStyleCount() {
        return this.styles.size();
    }

    public ResourceString.Type getStringType() {
        return this.isUTF8() ? ResourceString.Type.UTF8 : ResourceString.Type.UTF16;
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.STRING_POOL;
    }

    private int getOffsetSize() {
        return (this.strings.size() + this.styles.size()) * 4;
    }

    public boolean isUTF8() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isSorted() {
        return (this.flags & 1) != 0;
    }

    private List<String> readStrings(ByteBuffer buffer, int offset, int count) {
        ArrayList<String> result = new ArrayList<String>();
        int previousOffset = -1;
        for (int i11 = 0; i11 < count; ++i11) {
            int stringOffset = offset + buffer.getInt();
            result.add(ResourceString.decodeString(buffer, stringOffset, this.getStringType()));
            if (stringOffset <= previousOffset) {
                this.alwaysDedup = true;
            }
            previousOffset = stringOffset;
        }
        return result;
    }

    private List<StringPoolStyle> readStyles(ByteBuffer buffer, int offset, int count) {
        ArrayList<StringPoolStyle> result = new ArrayList<StringPoolStyle>();
        for (int i11 = 0; i11 < count; ++i11) {
            int styleOffset = offset + buffer.getInt();
            result.add(StringPoolStyle.create(buffer, styleOffset, this));
        }
        return result;
    }

    protected int writeStrings(DataOutput payload, ByteBuffer offsets, int options) throws IOException {
        int stringOffset = 0;
        HashMap<String, Integer> used = new HashMap<String, Integer>();
        boolean shouldShrink = (options & 1) != 0 || this.alwaysDedup;
        for (String string : this.strings) {
            if (shouldShrink && used.containsKey(string)) {
                Integer offset = (Integer)used.get(string);
                offsets.putInt(offset == null ? 0 : offset);
                continue;
            }
            byte[] encodedString = ResourceString.encodeString(string, this.getStringType());
            payload.write(encodedString);
            used.put(string, stringOffset);
            offsets.putInt(stringOffset);
            stringOffset += encodedString.length;
        }
        stringOffset = StringPoolChunk.writePad(payload, stringOffset);
        return stringOffset;
    }

    protected int writeStyles(DataOutput payload, ByteBuffer offsets, int options) throws IOException {
        boolean shouldShrink;
        int styleOffset = 0;
        boolean bl2 = shouldShrink = (options & 1) != 0 || this.alwaysDedup;
        if (this.styles.size() > 0) {
            HashMap<StringPoolStyle, Integer> used = new HashMap<StringPoolStyle, Integer>();
            for (StringPoolStyle style : this.styles) {
                if (shouldShrink && used.containsKey(style)) {
                    Integer offset = (Integer)used.get(style);
                    offsets.putInt(offset == null ? 0 : offset);
                    continue;
                }
                byte[] encodedStyle = style.toByteArray(options);
                payload.write(encodedStyle);
                used.put(style, styleOffset);
                offsets.putInt(styleOffset);
                styleOffset += encodedStyle.length;
            }
            payload.writeInt(-1);
            styleOffset += 4;
            payload.writeInt(-1);
            styleOffset += 4;
            styleOffset = StringPoolChunk.writePad(payload, styleOffset);
        }
        return styleOffset;
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        output.putInt(this.strings.size());
        output.putInt(this.styles.size());
        output.putInt(this.flags);
        output.putInt(this.getHeaderSize() + this.getOffsetSize());
        output.putInt(0);
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, int options) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int stringOffset = 0;
        ByteBuffer offsets = ByteBuffer.allocate(this.getOffsetSize());
        offsets.order(ByteOrder.LITTLE_ENDIAN);
        try (LittleEndianDataOutputStream payload = new LittleEndianDataOutputStream(baos);){
            stringOffset = this.writeStrings(payload, offsets, options);
            this.writeStyles(payload, offsets, options);
        }
        output.write(offsets.array());
        output.write(baos.toByteArray());
        if (!this.styles.isEmpty()) {
            header.putInt(24, this.getHeaderSize() + this.getOffsetSize() + stringOffset);
        }
    }

    public void setAlwaysDedup(boolean alwaysDedup) {
        this.alwaysDedup = alwaysDedup;
    }

    @AutoValue
    protected static abstract class StringPoolSpan
    implements SerializableResource {
        static final int SPAN_LENGTH = 12;

        protected StringPoolSpan() {
        }

        public abstract int nameIndex();

        final StringPoolSpan withNameIndex(int nameIndex) {
            return new AutoValue_StringPoolChunk_StringPoolSpan(nameIndex, this.start(), this.stop(), this.parent());
        }

        public abstract int start();

        public abstract int stop();

        public abstract StringPoolChunk parent();

        static StringPoolSpan create(ByteBuffer buffer, StringPoolChunk parent, int nameIndex) {
            int start = buffer.getInt();
            int stop = buffer.getInt();
            return new AutoValue_StringPoolChunk_StringPoolSpan(nameIndex, start, stop, parent);
        }

        static StringPoolSpan create(ByteBuffer buffer, int offset, StringPoolChunk parent) {
            int nameIndex = buffer.getInt(offset);
            int start = buffer.getInt(offset + 4);
            int stop = buffer.getInt(offset + 8);
            return new AutoValue_StringPoolChunk_StringPoolSpan(nameIndex, start, stop, parent);
        }

        @Override
        public final byte[] toByteArray() {
            return this.toByteArray(0);
        }

        @Override
        public final byte[] toByteArray(int options) {
            ByteBuffer buffer = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.nameIndex());
            buffer.putInt(this.start());
            buffer.putInt(this.stop());
            return buffer.array();
        }

        public String toString() {
            return String.format(Locale.US, "StringPoolSpan{%s, start=%d, stop=%d}", this.parent().getString(this.nameIndex()), this.start(), this.stop());
        }
    }

    @AutoValue
    protected static abstract class StringPoolStyle
    implements SerializableResource {
        static final int RES_STRING_POOL_SPAN_END = -1;

        protected StringPoolStyle() {
        }

        public abstract List<StringPoolSpan> spans();

        static StringPoolStyle create(ByteBuffer buffer, int offset, StringPoolChunk parent) {
            ArrayList<StringPoolSpan> spans = new ArrayList<StringPoolSpan>();
            int nameIndex = buffer.getInt(offset);
            while (nameIndex != -1) {
                spans.add(StringPoolSpan.create(buffer, offset, parent));
                nameIndex = buffer.getInt(offset += 12);
            }
            return StringPoolStyle.create(Collections.unmodifiableList(spans));
        }

        static StringPoolStyle create(ByteBuffer buffer, StringPoolChunk parent) {
            ArrayList<StringPoolSpan> spans = new ArrayList<StringPoolSpan>();
            int nameIndex = buffer.getInt();
            while (nameIndex != -1) {
                spans.add(StringPoolSpan.create(buffer, parent, nameIndex));
                nameIndex = buffer.getInt();
            }
            return StringPoolStyle.create(Collections.unmodifiableList(spans));
        }

        static StringPoolStyle create(List<StringPoolSpan> spans) {
            return new AutoValue_StringPoolChunk_StringPoolStyle(spans);
        }

        @Override
        public byte[] toByteArray() throws IOException {
            return this.toByteArray(0);
        }

        @Override
        public byte[] toByteArray(int options) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (LittleEndianDataOutputStream payload = new LittleEndianDataOutputStream(baos);){
                for (StringPoolSpan span : this.spans()) {
                    byte[] encodedSpan = span.toByteArray(options);
                    if (encodedSpan.length != 12) {
                        throw new IllegalStateException("Encountered a span of invalid length.");
                    }
                    payload.write(encodedSpan);
                }
                payload.writeInt(-1);
            }
            return baos.toByteArray();
        }

        public String toString() {
            return String.format(Locale.US, "StringPoolStyle{spans=%s}", this.spans());
        }
    }
}

