/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.AutoValue_TypeChunk_Entry;
import apk.arsc.Chunk;
import apk.arsc.PackageChunk;
import apk.arsc.ResourceConfiguration;
import apk.arsc.ResourceIdentifier;
import apk.arsc.ResourceTableChunk;
import apk.arsc.ResourceValue;
import apk.arsc.SerializableResource;
import apk.arsc.StringPoolChunk;
import apk.base.Preconditions;
import apk.io.LittleEndianDataOutputStream;
import com.google.auto.value.AutoValue;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class TypeChunk
extends Chunk {
    private static final int FLAG_SPARSE = 1;
    static final int HEADER_SIZE = 72;
    private int id;
    private int flags;
    private int entryCount;
    private final int entriesStart;
    private ResourceConfiguration configuration;
    protected final Map<Integer, Entry> entries = new TreeMap<Integer, Entry>();

    protected TypeChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.id = buffer.get() & 0xFF;
        this.flags = buffer.get() & 0xFF;
        buffer.position(buffer.position() + 2);
        this.entryCount = buffer.getInt();
        this.entriesStart = buffer.getInt();
        this.configuration = ResourceConfiguration.create(buffer);
    }

    @Override
    protected void init(ByteBuffer buffer) {
        int offset = this.offset + this.entriesStart;
        if (this.hasSparseEntries()) {
            this.initSparseEntries(buffer, offset);
        } else {
            this.initDenseEntries(buffer, offset);
        }
    }

    private void initSparseEntries(ByteBuffer buffer, int offset) {
        for (int i11 = 0; i11 < this.entryCount; ++i11) {
            int index = buffer.getShort() & 0xFFFF;
            int entryOffset = (buffer.getShort() & 0xFFFF) * 4;
            Entry entry = Entry.create(buffer, offset + entryOffset, this, index);
            this.entries.put(index, entry);
        }
    }

    private void initDenseEntries(ByteBuffer buffer, int offset) {
        for (int i11 = 0; i11 < this.entryCount; ++i11) {
            int entryOffset = buffer.getInt();
            if (entryOffset == -1) continue;
            Entry entry = Entry.create(buffer, offset + entryOffset, this, i11);
            this.entries.put(i11, entry);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TypeChunk[id:").append(this.id).append(", typeName:").append(this.getTypeName()).append(", configuration:").append(this.getConfiguration()).append(", originalEntryCount:").append(this.getTotalEntryCount()).append(", entries:");
        for (Map.Entry<Integer, Entry> entry : this.entries.entrySet()) {
            builder.append("<").append(entry.getKey()).append("->").append(entry.getValue()).append("> ");
        }
        builder.append("]");
        return builder.toString();
    }

    public void setEntries(Map<Integer, Entry> entries, int totalCount) {
        this.entries.clear();
        this.entries.putAll(entries);
        this.entryCount = totalCount;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int newId) {
        Preconditions.checkState(newId >= 1);
        Preconditions.checkState(Preconditions.checkNotNull(this.getPackageChunk()).getTypeStringPool().getStringCount() >= newId);
        this.id = newId;
    }

    public boolean hasSparseEntries() {
        return (this.flags & 1) != 0;
    }

    public void setSparseEntries(boolean sparseEntries) {
        this.flags = this.flags & 0xFFFFFFFE | (sparseEntries ? 1 : 0);
    }

    public String getTypeName() {
        PackageChunk packageChunk = this.getPackageChunk();
        Preconditions.checkNotNull(packageChunk, "%s has no parent package.", this.getClass());
        return packageChunk.getTypeString(this.getId());
    }

    public ResourceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ResourceConfiguration configuration) {
        this.configuration = configuration;
    }

    public int getTotalEntryCount() {
        return this.entryCount;
    }

    public void setTotalEntryCount(int newEntryCount) {
        this.entryCount = newEntryCount;
    }

    public Map<Integer, Entry> getEntries() {
        return Collections.unmodifiableMap(this.entries);
    }

    public boolean containsResource(ResourceIdentifier resourceId) {
        PackageChunk packageChunk = Preconditions.checkNotNull(this.getPackageChunk());
        int packageId = packageChunk.getId();
        int typeId = this.getId();
        return resourceId.packageId() == packageId && resourceId.typeId() == typeId && this.entries.containsKey(resourceId.entryId());
    }

    public void overrideEntries(Map<Integer, Entry> entries) {
        for (Map.Entry<Integer, Entry> entry : entries.entrySet()) {
            int index = entry.getKey() != null ? entry.getKey() : -1;
            this.overrideEntry(index, entry.getValue());
        }
    }

    public void overrideEntry(int index, @Nullable Entry entry) {
        if (index >= 0 && index < this.entryCount) {
            if (entry != null) {
                this.entries.put(index, entry);
            } else {
                this.entries.remove(index);
            }
        }
    }

    protected String getString(int index) {
        ResourceTableChunk resourceTable = this.getResourceTableChunk();
        Preconditions.checkNotNull(resourceTable, "%s has no resource table.", this.getClass());
        return resourceTable.getStringPool().getString(index);
    }

    protected String getKeyName(int index) {
        PackageChunk packageChunk = this.getPackageChunk();
        Preconditions.checkNotNull(packageChunk, "%s has no parent package.", this.getClass());
        StringPoolChunk keyPool = packageChunk.getKeyStringPool();
        Preconditions.checkNotNull(keyPool, "%s's parent package has no key pool.", this.getClass());
        return keyPool.getString(index);
    }

    @Nullable
    private ResourceTableChunk getResourceTableChunk() {
        Chunk chunk;
        for (chunk = this.getParent(); chunk != null && !(chunk instanceof ResourceTableChunk); chunk = chunk.getParent()) {
        }
        return chunk != null && chunk instanceof ResourceTableChunk ? (ResourceTableChunk)chunk : null;
    }

    @Nullable
    public PackageChunk getPackageChunk() {
        Chunk chunk;
        for (chunk = this.getParent(); chunk != null && !(chunk instanceof PackageChunk); chunk = chunk.getParent()) {
        }
        return chunk != null && chunk instanceof PackageChunk ? (PackageChunk)chunk : null;
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.TABLE_TYPE;
    }

    private int getOffsetSize() {
        return this.entryCount * 4;
    }

    private int writeEntries(DataOutput payload, ByteBuffer offsets, int options) throws IOException {
        int entryOffset = 0;
        if (this.hasSparseEntries()) {
            for (Map.Entry<Integer, Entry> mapEntry : this.entries.entrySet()) {
                Entry entry = mapEntry.getValue();
                byte[] encodedEntry = entry.toByteArray(options);
                payload.write(encodedEntry);
                offsets.putShort((short)(mapEntry.getKey() & 0xFFFF));
                offsets.putShort((short)(entryOffset / 4));
                Preconditions.checkState((entryOffset += encodedEntry.length) % 4 == 0);
            }
        } else {
            for (int i11 = 0; i11 < this.entryCount; ++i11) {
                Entry entry = this.entries.get(i11);
                if (entry == null) {
                    offsets.putInt(-1);
                    continue;
                }
                byte[] encodedEntry = entry.toByteArray(options);
                payload.write(encodedEntry);
                offsets.putInt(entryOffset);
                entryOffset += encodedEntry.length;
            }
        }
        entryOffset = TypeChunk.writePad(payload, entryOffset);
        return entryOffset;
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        int entriesStart = this.getHeaderSize() + this.getOffsetSize();
        output.put((byte)this.id);
        output.put((byte)this.flags);
        output.putShort((short)0);
        output.putInt(this.entryCount);
        output.putInt(entriesStart);
        output.put(this.configuration.toByteArray());
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, int options) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteBuffer offsets = ByteBuffer.allocate(this.getOffsetSize()).order(ByteOrder.LITTLE_ENDIAN);
        try (LittleEndianDataOutputStream payload = new LittleEndianDataOutputStream(baos);){
            this.writeEntries(payload, offsets, options);
        }
        output.write(offsets.array());
        output.write(baos.toByteArray());
    }

    @AutoValue
    public static abstract class Entry
    implements SerializableResource {
        public static final int NO_ENTRY = -1;
        private static final int FLAG_COMPLEX = 1;
        static final int FLAG_PUBLIC = 2;
        private static final int MAPPING_SIZE = 12;
        public static final int SIMPLE_HEADERSIZE = 8;
        public static final int COMPLEX_HEADER_SIZE = 16;

        public abstract int headerSize();

        public abstract int flags();

        public abstract int keyIndex();

        @Nullable
        public abstract ResourceValue value();

        public abstract Map<Integer, ResourceValue> values();

        public abstract int parentEntry();

        public abstract TypeChunk parent();

        public abstract int typeChunkIndex();

        public static Builder builder() {
            return new AutoValue_TypeChunk_Entry.Builder();
        }

        public abstract Builder toBuilder();

        public Entry withKeyIndex(int keyIndex) {
            return this.toBuilder().keyIndex(keyIndex).build();
        }

        public Entry withValue(@Nullable ResourceValue value) {
            return this.toBuilder().value(value).build();
        }

        public Entry withValues(Map<Integer, ResourceValue> values) {
            return this.toBuilder().values(values).build();
        }

        public final String typeName() {
            return this.parent().getTypeName();
        }

        public final int size() {
            return this.headerSize() + (this.isComplex() ? this.values().size() * 12 : 8);
        }

        public final String key() {
            return this.parent().getKeyName(this.keyIndex());
        }

        public final boolean isComplex() {
            return (this.flags() & 1) != 0;
        }

        public final boolean isPublic() {
            return (this.flags() & 2) != 0;
        }

        public static Entry create(ByteBuffer buffer, int offset, TypeChunk parent, int typeChunkIndex) {
            int position = buffer.position();
            buffer.position(offset);
            Entry result = Entry.newInstance(buffer, parent, typeChunkIndex);
            buffer.position(position);
            return result;
        }

        private static Entry newInstance(ByteBuffer buffer, TypeChunk parent, int typeChunkIndex) {
            int headerSize = buffer.getShort() & 0xFFFF;
            int flags = buffer.getShort() & 0xFFFF;
            int keyIndex = buffer.getInt();
            ResourceValue value = null;
            LinkedHashMap<Integer, ResourceValue> values = new LinkedHashMap<Integer, ResourceValue>();
            int parentEntry = 0;
            if ((flags & 1) != 0) {
                parentEntry = buffer.getInt();
                int valueCount = buffer.getInt();
                for (int i11 = 0; i11 < valueCount; ++i11) {
                    values.put(buffer.getInt(), ResourceValue.create(buffer));
                }
            } else {
                value = ResourceValue.create(buffer);
            }
            return Entry.builder().headerSize(headerSize).flags(flags).keyIndex(keyIndex).value(value).values(values).parentEntry(parentEntry).parent(parent).typeChunkIndex(typeChunkIndex).build();
        }

        @Override
        public final byte[] toByteArray() {
            return this.toByteArray(0);
        }

        @Override
        public final byte[] toByteArray(int options) {
            ByteBuffer buffer = ByteBuffer.allocate(this.size());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putShort((short)this.headerSize());
            int flagMask = (options & 2) != 0 ? -3 : -1;
            buffer.putShort((short)(this.flags() & flagMask));
            buffer.putInt(this.keyIndex());
            if (this.isComplex()) {
                buffer.putInt(this.parentEntry());
                buffer.putInt(this.values().size());
                for (Map.Entry<Integer, ResourceValue> entry : this.values().entrySet()) {
                    buffer.putInt(entry.getKey());
                    buffer.put(entry.getValue().toByteArray(options));
                }
            } else {
                ResourceValue value = this.value();
                Preconditions.checkNotNull(value, "A non-complex TypeChunk entry must have a value.");
                buffer.put(value.toByteArray());
            }
            return buffer.array();
        }

        public final String toString() {
            return String.format("Entry{key=%s,value=%s,values=%s}", this.key(), this.value(), this.values());
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder headerSize(int var1);

            abstract Builder flags(int var1);

            abstract Builder keyIndex(int var1);

            abstract Builder value(@Nullable ResourceValue var1);

            abstract Builder values(Map<Integer, ResourceValue> var1);

            abstract Builder parentEntry(int var1);

            abstract Builder parent(TypeChunk var1);

            abstract Builder typeChunkIndex(int var1);

            abstract Entry build();
        }
    }
}

