/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.Chunk;
import apk.base.Preconditions;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class TypeSpecChunk
extends Chunk {
    private static final int SPEC_PUBLIC = 0x40000000;
    private int id;
    private int[] resources;

    protected TypeSpecChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.id = buffer.get() & 0xFF;
        buffer.position(buffer.position() + 3);
        int resourceCount = buffer.getInt();
        this.resources = new int[resourceCount];
        for (int i11 = 0; i11 < resourceCount; ++i11) {
            this.resources[i11] = buffer.getInt();
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int newId) {
        Preconditions.checkState(newId >= 1);
        this.id = newId;
    }

    public int getResourceCount() {
        return this.getResources().length;
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.TABLE_TYPE_SPEC;
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        super.writeHeader(output);
        output.putInt(this.id);
        output.putInt(this.resources.length);
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, int options) throws IOException {
        int resourceMask = (options & 2) != 0 ? -1073741825 : -1;
        for (int resource : this.getResources()) {
            output.writeInt(resource & resourceMask);
        }
    }

    public int[] getResources() {
        return this.resources;
    }

    public void setResources(int[] resources) {
        this.resources = resources;
    }
}

