/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import java.nio.ByteBuffer;

final class UtfUtil {
    private UtfUtil() {
    }

    static char[] decodeUtf8OrModifiedUtf8(ByteBuffer utf8Buffer, int characterCount) {
        char[] charBuffer = new char[characterCount];
        int offset = 0;
        while (offset < characterCount) {
            offset = UtfUtil.decodeUtf8OrModifiedUtf8CodePoint(utf8Buffer, charBuffer, offset);
        }
        return charBuffer;
    }

    static int decodeUtf8OrModifiedUtf8CodePoint(ByteBuffer in2, char[] out, int offset) {
        byte one = in2.get();
        if ((one & 0x80) == 0) {
            out[offset++] = (char)one;
            return offset;
        }
        byte two = in2.get();
        if ((one & 0x20) == 0) {
            out[offset++] = (char)((one & 0x1F) << 6 | two & 0x3F);
            return offset;
        }
        byte three = in2.get();
        if ((one & 0x10) == 0) {
            out[offset++] = (char)((one & 0xF) << 12 | (two & 0x3F) << 6 | three & 0x3F);
            return offset;
        }
        byte four = in2.get();
        int codePoint = (one & 0xF) << 18 | (two & 0x3F) << 12 | (three & 0x3F) << 6 | four & 0x3F;
        out[offset++] = (char)((codePoint >> 10) + 55232 & 0xFFFF);
        out[offset++] = (char)((codePoint & 0x3FF) + 56320);
        return offset;
    }
}

