/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.AutoValue_XmlAttribute;
import apk.arsc.ResourceValue;
import apk.arsc.SerializableResource;
import apk.arsc.XmlNodeChunk;
import com.google.auto.value.AutoValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@AutoValue
public abstract class XmlAttribute
implements SerializableResource {
    public static final int SIZE = 20;

    public abstract int namespaceIndex();

    public abstract int nameIndex();

    public abstract int rawValueIndex();

    public abstract ResourceValue typedValue();

    public abstract XmlNodeChunk parent();

    public final String namespace() {
        return this.getString(this.namespaceIndex());
    }

    public final String name() {
        return this.getString(this.nameIndex());
    }

    public final String rawValue() {
        return this.getString(this.rawValueIndex());
    }

    public static XmlAttribute create(ByteBuffer buffer, XmlNodeChunk parent) {
        int namespace = buffer.getInt();
        int name = buffer.getInt();
        int rawValue = buffer.getInt();
        ResourceValue typedValue = ResourceValue.create(buffer);
        return XmlAttribute.create(namespace, name, rawValue, typedValue, parent);
    }

    public static XmlAttribute create(int namespace, int name, int rawValue, ResourceValue typedValue, XmlNodeChunk parent) {
        return new AutoValue_XmlAttribute(namespace, name, rawValue, typedValue, parent);
    }

    private String getString(int index) {
        return this.parent().getString(index);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(0);
    }

    @Override
    public byte[] toByteArray(int options) {
        ByteBuffer buffer = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.namespaceIndex());
        buffer.putInt(this.nameIndex());
        buffer.putInt(this.rawValueIndex());
        buffer.put(this.typedValue().toByteArray(options));
        return buffer.array();
    }

    public String toString() {
        return String.format("XmlAttribute{namespace=%s, name=%s, value=%s}", this.namespace(), this.name(), this.typedValue());
    }
}

