/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.Chunk;
import apk.arsc.ResourceValue;
import apk.arsc.XmlNodeChunk;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import javax.annotation.Nullable;

public final class XmlCdataChunk
extends XmlNodeChunk {
    private final int rawValue;
    private final ResourceValue resourceValue;

    protected XmlCdataChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.rawValue = buffer.getInt();
        this.resourceValue = ResourceValue.create(buffer);
    }

    public String getRawValue() {
        return this.getString(this.rawValue);
    }

    public ResourceValue getResourceValue() {
        return this.resourceValue;
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.XML_CDATA;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, int options) throws IOException {
        super.writePayload(output, header, options);
        output.writeInt(this.rawValue);
        output.write(this.resourceValue.toByteArray());
    }

    @Override
    public String toString() {
        return String.format(Locale.US, "XmlCdataChunk{line=%d, comment=%s, value=%s}", this.getLineNumber(), this.getComment(), this.getRawValue());
    }
}

