/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.Chunk;
import apk.arsc.XmlNodeChunk;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import javax.annotation.Nullable;

public final class XmlEndElementChunk
extends XmlNodeChunk {
    private final int namespace;
    private final int name;

    protected XmlEndElementChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.namespace = buffer.getInt();
        this.name = buffer.getInt();
    }

    public String getNamespace() {
        return this.getString(this.namespace);
    }

    public String getName() {
        return this.getString(this.name);
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.XML_END_ELEMENT;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, int options) throws IOException {
        super.writePayload(output, header, options);
        output.writeInt(this.namespace);
        output.writeInt(this.name);
    }

    @Override
    public String toString() {
        return String.format(Locale.US, "XmlEndElementChunk{line=%d, comment=%s, namespace=%s, name=%s}", this.getLineNumber(), this.getComment(), this.getNamespace(), this.getName());
    }
}

