/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.Chunk;
import apk.arsc.XmlNodeChunk;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import javax.annotation.Nullable;

public abstract class XmlNamespaceChunk
extends XmlNodeChunk {
    private final int prefix;
    private final int uri;

    protected XmlNamespaceChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.prefix = buffer.getInt();
        this.uri = buffer.getInt();
    }

    public String getPrefix() {
        return this.getString(this.prefix);
    }

    public String getUri() {
        return this.getString(this.uri);
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, int options) throws IOException {
        super.writePayload(output, header, options);
        output.writeInt(this.prefix);
        output.writeInt(this.uri);
    }

    @Override
    public String toString() {
        return String.format(Locale.US, "XmlNamespaceChunk{line=%d, comment=%s, prefix=%s, uri=%s}", this.getLineNumber(), this.getComment(), this.getPrefix(), this.getUri());
    }
}

