/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.Chunk;
import apk.arsc.XmlChunk;
import java.nio.ByteBuffer;
import java.util.Locale;
import javax.annotation.Nullable;

public abstract class XmlNodeChunk
extends Chunk {
    private XmlChunk xmlChunk;
    private final int lineNumber;
    private final int comment;

    protected XmlNodeChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.lineNumber = buffer.getInt();
        this.comment = buffer.getInt();
    }

    public boolean hasComment() {
        return this.comment != -1;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getComment() {
        return this.getString(this.comment);
    }

    protected String getString(int index) {
        if (index == -1) {
            return "";
        }
        if (this.xmlChunk == null) {
            for (Chunk parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof XmlChunk)) continue;
                this.xmlChunk = (XmlChunk)parent;
            }
        }
        if (this.xmlChunk != null) {
            return this.xmlChunk.getString(index);
        }
        throw new IllegalStateException("XmlNodeChunk did not have an XmlChunk parent.");
    }

    @Override
    protected final void writeHeader(ByteBuffer output) {
        super.writeHeader(output);
        output.putInt(this.lineNumber);
        output.putInt(this.comment);
    }

    public String toString() {
        return String.format(Locale.US, "XmlNodeChunk{line=%d, comment=%s}", this.getLineNumber(), this.getComment());
    }
}

