/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.Chunk;
import apk.arsc.ResourceIdentifier;
import apk.base.Preconditions;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class XmlResourceMapChunk
extends Chunk {
    private static final int RESOURCE_SIZE = 4;
    private final List<Integer> resources = new ArrayList<Integer>();

    protected XmlResourceMapChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        this.resources.addAll(this.enumerateResources(buffer));
    }

    private List<Integer> enumerateResources(ByteBuffer buffer) {
        int resourceCount = (this.getOriginalChunkSize() - this.getHeaderSize()) / 4;
        ArrayList<Integer> result = new ArrayList<Integer>(resourceCount);
        int offset = this.offset + this.getHeaderSize();
        buffer.mark();
        buffer.position(offset);
        for (int i11 = 0; i11 < resourceCount; ++i11) {
            result.add(buffer.getInt());
        }
        buffer.reset();
        return result;
    }

    public ResourceIdentifier getResourceId(int attributeId) {
        Preconditions.checkArgument(this.hasResourceId(attributeId), "Attribute ID is not a valid index.");
        return ResourceIdentifier.create(this.resources.get(attributeId));
    }

    public boolean hasResourceId(int attributeId) {
        return attributeId >= 0 && this.resources.size() > attributeId;
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.XML_RESOURCE_MAP;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, int options) throws IOException {
        super.writePayload(output, header, options);
        for (Integer resource : this.resources) {
            output.writeInt(resource);
        }
    }
}

