/*
 * Decompiled with CFR 0.152.
 */
package apk.arsc;

import apk.arsc.Chunk;
import apk.arsc.ResourceIdentifier;
import apk.arsc.ResourceValue;
import apk.arsc.XmlAttribute;
import apk.arsc.XmlNodeChunk;
import apk.base.Preconditions;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public final class XmlStartElementChunk
extends XmlNodeChunk {
    private final int namespace;
    private final int name;
    private final int attributeStart;
    private final int attributeCount;
    private final int idIndex;
    private final int classIndex;
    private final int styleIndex;
    private final List<XmlAttribute> attributes = new ArrayList<XmlAttribute>();

    protected XmlStartElementChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.namespace = buffer.getInt();
        this.name = buffer.getInt();
        this.attributeStart = buffer.getShort() & 0xFFFF;
        int attributeSize = buffer.getShort() & 0xFFFF;
        Preconditions.checkState(attributeSize == 20, "attributeSize is wrong size. Got %s, want %s", attributeSize, 20);
        this.attributeCount = buffer.getShort() & 0xFFFF;
        this.idIndex = (buffer.getShort() & 0xFFFF) - 1;
        this.classIndex = (buffer.getShort() & 0xFFFF) - 1;
        this.styleIndex = (buffer.getShort() & 0xFFFF) - 1;
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        this.attributes.addAll(this.enumerateAttributes(buffer));
    }

    private List<XmlAttribute> enumerateAttributes(ByteBuffer buffer) {
        int offset;
        ArrayList<XmlAttribute> result = new ArrayList<XmlAttribute>(this.attributeCount);
        int endOffset = offset + 20 * this.attributeCount;
        buffer.mark();
        buffer.position(offset);
        for (offset = this.offset + this.getHeaderSize() + this.attributeStart; offset < endOffset; offset += 20) {
            result.add(XmlAttribute.create(buffer, this));
        }
        buffer.reset();
        return result;
    }

    public void remapReferences(Map<Integer, Integer> remapping) {
        HashMap<Integer, XmlAttribute> newEntries = new HashMap<Integer, XmlAttribute>();
        int count = 0;
        for (XmlAttribute xmlAttribute : this.attributes) {
            int valueData;
            ResourceValue value = xmlAttribute.typedValue();
            if (value.type() == ResourceValue.Type.REFERENCE && ResourceIdentifier.create(valueData = value.data()).packageId() != 1 && remapping.containsKey(valueData)) {
                int data = Preconditions.checkNotNull(remapping.get(valueData));
                XmlAttribute newAttribute = XmlAttribute.create(xmlAttribute.namespaceIndex(), xmlAttribute.nameIndex(), xmlAttribute.rawValueIndex(), xmlAttribute.typedValue().withData(data), xmlAttribute.parent());
                newEntries.put(count, newAttribute);
            }
            ++count;
        }
        for (Map.Entry entry : newEntries.entrySet()) {
            this.attributes.set((Integer)entry.getKey(), (XmlAttribute)entry.getValue());
        }
    }

    public void setAttribute(int index, XmlAttribute attribute) {
        this.attributes.set(index, attribute);
    }

    public void addAttribute(XmlAttribute attribute) {
        this.attributes.add(attribute);
    }

    public void addAttribute(int i11, XmlAttribute attribute) {
        this.attributes.add(i11, attribute);
    }

    public String getNamespace() {
        return this.getString(this.namespace);
    }

    public String getName() {
        return this.getString(this.name);
    }

    public List<XmlAttribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.XML_START_ELEMENT;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, int options) throws IOException {
        super.writePayload(output, header, options);
        output.writeInt(this.namespace);
        output.writeInt(this.name);
        output.writeShort(20);
        output.writeShort(20);
        output.writeShort((short)this.attributes.size());
        output.writeShort((short)(this.idIndex + 1));
        output.writeShort((short)(this.classIndex + 1));
        output.writeShort((short)(this.styleIndex + 1));
        for (XmlAttribute attribute : this.attributes) {
            output.write(attribute.toByteArray(options));
        }
    }

    @Override
    public String toString() {
        return String.format(Locale.US, "XmlStartElementChunk{line=%d, comment=%s, namespace=%s, name=%s, attributes=%s}", this.getLineNumber(), this.getComment(), this.getNamespace(), this.getName(), this.attributes.toString());
    }
}

