/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.analysis;

import com.android.tools.smali.dexlib2.AccessFlags;
import com.android.tools.smali.dexlib2.HiddenApiRestriction;
import com.android.tools.smali.dexlib2.analysis.AnalyzedMethodUtil;
import com.android.tools.smali.dexlib2.analysis.ClassPath;
import com.android.tools.smali.dexlib2.analysis.TypeProto;
import com.android.tools.smali.dexlib2.analysis.UnresolvedClassException;
import com.android.tools.smali.dexlib2.analysis.util.MemoizingSupplier;
import com.android.tools.smali.dexlib2.analysis.util.TypeProtoUtils;
import com.android.tools.smali.dexlib2.base.reference.BaseMethodReference;
import com.android.tools.smali.dexlib2.iface.Annotation;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.Field;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.MethodImplementation;
import com.android.tools.smali.dexlib2.iface.MethodParameter;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.util.AlignmentUtils;
import com.android.tools.smali.dexlib2.util.MethodUtil;
import com.android.tools.smali.util.AbstractIterator;
import com.android.tools.smali.util.ExceptionWithContext;
import com.android.tools.smali.util.IteratorUtils;
import com.android.tools.smali.util.SparseArray;
import com.android.tools.smali.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClassProto
implements TypeProto {
    private static final byte REFERENCE = 0;
    private static final byte WIDE = 1;
    private static final byte OTHER = 2;
    @Nonnull
    protected final ClassPath classPath;
    @Nonnull
    protected final String type;
    protected boolean vtableFullyResolved = true;
    protected boolean interfacesFullyResolved = true;
    protected Set<String> unresolvedInterfaces = null;
    @Nonnull
    private final Supplier<ClassDef> classDefSupplier = MemoizingSupplier.memoize(new Supplier<ClassDef>(){

        @Override
        public ClassDef get() {
            return ClassProto.this.classPath.getClassDef(ClassProto.this.type);
        }
    });
    @Nonnull
    private final Supplier<LinkedHashMap<String, ClassDef>> preDefaultMethodInterfaceSupplier = MemoizingSupplier.memoize(new Supplier<LinkedHashMap<String, ClassDef>>(){

        @Override
        public LinkedHashMap<String, ClassDef> get() {
            HashSet<String> unresolvedInterfaces = new HashSet<String>(0);
            LinkedHashMap<String, ClassDef> interfaces = new LinkedHashMap<String, ClassDef>();
            try {
                for (String interfaceType : ClassProto.this.getClassDef().getInterfaces()) {
                    if (interfaces.containsKey(interfaceType)) continue;
                    try {
                        ClassDef interfaceDef = ClassProto.this.classPath.getClassDef(interfaceType);
                        interfaces.put(interfaceType, interfaceDef);
                    }
                    catch (UnresolvedClassException ex2) {
                        interfaces.put(interfaceType, null);
                        unresolvedInterfaces.add(interfaceType);
                        ClassProto.this.interfacesFullyResolved = false;
                    }
                    ClassProto interfaceProto = (ClassProto)ClassProto.this.classPath.getClass(interfaceType);
                    for (String superInterface : interfaceProto.getInterfaces().keySet()) {
                        if (interfaces.containsKey(superInterface)) continue;
                        interfaces.put(superInterface, interfaceProto.getInterfaces().get(superInterface));
                    }
                    if (interfaceProto.interfacesFullyResolved) continue;
                    unresolvedInterfaces.addAll(interfaceProto.getUnresolvedInterfaces());
                    ClassProto.this.interfacesFullyResolved = false;
                }
            }
            catch (UnresolvedClassException ex3) {
                interfaces.put(ClassProto.this.type, null);
                unresolvedInterfaces.add(ClassProto.this.type);
                ClassProto.this.interfacesFullyResolved = false;
            }
            if (ClassProto.this.isInterface() && !interfaces.containsKey(ClassProto.this.getType())) {
                interfaces.put(ClassProto.this.getType(), null);
            }
            String superclass = ClassProto.this.getSuperclass();
            try {
                if (superclass != null) {
                    ClassProto superclassProto = (ClassProto)ClassProto.this.classPath.getClass(superclass);
                    for (String superclassInterface : superclassProto.getInterfaces().keySet()) {
                        if (interfaces.containsKey(superclassInterface)) continue;
                        interfaces.put(superclassInterface, null);
                    }
                    if (!superclassProto.interfacesFullyResolved) {
                        unresolvedInterfaces.addAll(superclassProto.getUnresolvedInterfaces());
                        ClassProto.this.interfacesFullyResolved = false;
                    }
                }
            }
            catch (UnresolvedClassException ex4) {
                unresolvedInterfaces.add(superclass);
                ClassProto.this.interfacesFullyResolved = false;
            }
            if (unresolvedInterfaces.size() > 0) {
                ClassProto.this.unresolvedInterfaces = unresolvedInterfaces;
            }
            return interfaces;
        }
    });
    @Nonnull
    private final Supplier<LinkedHashMap<String, ClassDef>> postDefaultMethodInterfaceSupplier = MemoizingSupplier.memoize(new Supplier<LinkedHashMap<String, ClassDef>>(){

        @Override
        public LinkedHashMap<String, ClassDef> get() {
            HashSet<String> unresolvedInterfaces = new HashSet<String>(0);
            LinkedHashMap<String, ClassDef> interfaces = new LinkedHashMap<String, ClassDef>();
            String superclass = ClassProto.this.getSuperclass();
            if (superclass != null) {
                ClassProto superclassProto = (ClassProto)ClassProto.this.classPath.getClass(superclass);
                for (String superclassInterface : superclassProto.getInterfaces().keySet()) {
                    interfaces.put(superclassInterface, null);
                }
                if (!superclassProto.interfacesFullyResolved) {
                    unresolvedInterfaces.addAll(superclassProto.getUnresolvedInterfaces());
                    ClassProto.this.interfacesFullyResolved = false;
                }
            }
            try {
                for (String interfaceType : ClassProto.this.getClassDef().getInterfaces()) {
                    if (interfaces.containsKey(interfaceType)) continue;
                    ClassProto interfaceProto = (ClassProto)ClassProto.this.classPath.getClass(interfaceType);
                    try {
                        for (Map.Entry<String, ClassDef> entry : interfaceProto.getInterfaces().entrySet()) {
                            if (interfaces.containsKey(entry.getKey())) continue;
                            interfaces.put(entry.getKey(), entry.getValue());
                        }
                    }
                    catch (UnresolvedClassException ex2) {
                        interfaces.put(interfaceType, null);
                        unresolvedInterfaces.add(interfaceType);
                        ClassProto.this.interfacesFullyResolved = false;
                    }
                    if (!interfaceProto.interfacesFullyResolved) {
                        unresolvedInterfaces.addAll(interfaceProto.getUnresolvedInterfaces());
                        ClassProto.this.interfacesFullyResolved = false;
                    }
                    try {
                        ClassDef interfaceDef = ClassProto.this.classPath.getClassDef(interfaceType);
                        interfaces.put(interfaceType, interfaceDef);
                    }
                    catch (UnresolvedClassException ex3) {
                        interfaces.put(interfaceType, null);
                        unresolvedInterfaces.add(interfaceType);
                        ClassProto.this.interfacesFullyResolved = false;
                    }
                }
            }
            catch (UnresolvedClassException ex4) {
                interfaces.put(ClassProto.this.type, null);
                unresolvedInterfaces.add(ClassProto.this.type);
                ClassProto.this.interfacesFullyResolved = false;
            }
            if (unresolvedInterfaces.size() > 0) {
                ClassProto.this.unresolvedInterfaces = unresolvedInterfaces;
            }
            return interfaces;
        }
    });
    @Nonnull
    private final Supplier<SparseArray<FieldReference>> dalvikInstanceFieldsSupplier = MemoizingSupplier.memoize(new Supplier<SparseArray<FieldReference>>(){

        @Override
        public SparseArray<FieldReference> get() {
            int fieldOffset;
            int front;
            ArrayList<Field> fields = this.getSortedInstanceFields(ClassProto.this.getClassDef());
            int fieldCount = fields.size();
            byte[] fieldTypes = new byte[fields.size()];
            for (int i11 = 0; i11 < fieldCount; ++i11) {
                fieldTypes[i11] = ClassProto.getFieldType(fields.get(i11));
            }
            int back = fields.size() - 1;
            for (front = 0; front < fieldCount; ++front) {
                if (fieldTypes[front] != 0) {
                    while (back > front) {
                        if (fieldTypes[back] == 0) {
                            this.swap(fieldTypes, fields, front, back--);
                            break;
                        }
                        --back;
                    }
                }
                if (fieldTypes[front] != 0) break;
            }
            int startFieldOffset = 8;
            String superclassType = ClassProto.this.getSuperclass();
            ClassProto superclass = null;
            if (superclassType != null) {
                superclass = (ClassProto)ClassProto.this.classPath.getClass(superclassType);
                startFieldOffset = superclass.getNextFieldOffset();
            }
            int fieldIndexMod = startFieldOffset % 8 == 0 ? 0 : 1;
            if (front < fieldCount && front % 2 != fieldIndexMod) {
                if (fieldTypes[front] == 1) {
                    for (back = fieldCount - 1; back > front; --back) {
                        if (fieldTypes[back] != 2) continue;
                        this.swap(fieldTypes, fields, front++, back);
                        break;
                    }
                } else {
                    ++front;
                }
            }
            back = fieldCount - 1;
            while (front < fieldCount) {
                if (fieldTypes[front] != 1) {
                    while (back > front) {
                        if (fieldTypes[back] == 1) {
                            this.swap(fieldTypes, fields, front, back--);
                            break;
                        }
                        --back;
                    }
                }
                if (fieldTypes[front] != 1) break;
                ++front;
            }
            SparseArray<FieldReference> superFields = superclass != null ? superclass.getInstanceFields() : new SparseArray();
            int superFieldCount = superFields.size();
            int totalFieldCount = superFieldCount + fieldCount;
            SparseArray<FieldReference> instanceFields = new SparseArray<FieldReference>(totalFieldCount);
            if (superclass != null && superFieldCount > 0) {
                for (int i12 = 0; i12 < superFieldCount; ++i12) {
                    instanceFields.append(superFields.keyAt(i12), superFields.valueAt(i12));
                }
                fieldOffset = instanceFields.keyAt(superFieldCount - 1);
                FieldReference lastSuperField = superFields.valueAt(superFieldCount - 1);
                char fieldType = lastSuperField.getType().charAt(0);
                fieldOffset = fieldType == 'J' || fieldType == 'D' ? (fieldOffset += 8) : (fieldOffset += 4);
            } else {
                fieldOffset = 8;
            }
            boolean gotDouble = false;
            for (int i13 = 0; i13 < fieldCount; ++i13) {
                FieldReference field = fields.get(i13);
                if (fieldTypes[i13] == 1 && !gotDouble) {
                    if (fieldOffset % 8 != 0) {
                        assert (fieldOffset % 8 == 4);
                        fieldOffset += 4;
                    }
                    gotDouble = true;
                }
                instanceFields.append(fieldOffset, field);
                if (fieldTypes[i13] == 1) {
                    fieldOffset += 8;
                    continue;
                }
                fieldOffset += 4;
            }
            return instanceFields;
        }

        @Nonnull
        private ArrayList<Field> getSortedInstanceFields(@Nonnull ClassDef classDef) {
            ArrayList fields = (ArrayList)IteratorUtils.toList(classDef.getInstanceFields());
            Collections.sort(fields);
            return fields;
        }

        private void swap(byte[] fieldTypes, List<Field> fields, int position1, int position2) {
            byte tempType = fieldTypes[position1];
            fieldTypes[position1] = fieldTypes[position2];
            fieldTypes[position2] = tempType;
            Field tempField = fields.set(position1, fields.get(position2));
            fields.set(position2, tempField);
        }
    });
    @Nonnull
    private final Supplier<SparseArray<FieldReference>> artInstanceFieldsSupplier = MemoizingSupplier.memoize(new Supplier<SparseArray<FieldReference>>(){

        @Override
        public SparseArray<FieldReference> get() {
            PriorityQueue<FieldGap> gaps = new PriorityQueue<FieldGap>();
            SparseArray<FieldReference> linkedFields = new SparseArray<FieldReference>();
            ArrayList<Field> fields = this.getSortedInstanceFields(ClassProto.this.getClassDef());
            int fieldOffset = 0;
            String superclassType = ClassProto.this.getSuperclass();
            if (superclassType != null) {
                ClassProto superclass = (ClassProto)ClassProto.this.classPath.getClass(superclassType);
                SparseArray<FieldReference> superFields = superclass.getInstanceFields();
                FieldReference field = null;
                int lastOffset = 0;
                for (int i11 = 0; i11 < superFields.size(); ++i11) {
                    int offset = superFields.keyAt(i11);
                    field = superFields.valueAt(i11);
                    linkedFields.put(offset, field);
                    lastOffset = offset;
                }
                if (field != null) {
                    fieldOffset = lastOffset + this.getFieldSize(field);
                }
            }
            for (Field field : fields) {
                FieldGap gap;
                int fieldSize = this.getFieldSize(field);
                if (!AlignmentUtils.isAligned(fieldOffset, fieldSize)) {
                    int oldOffset = fieldOffset;
                    fieldOffset = AlignmentUtils.alignOffset(fieldOffset, fieldSize);
                    this.addFieldGap(oldOffset, fieldOffset, gaps);
                }
                if ((gap = (FieldGap)gaps.peek()) != null && gap.size >= fieldSize) {
                    gaps.poll();
                    linkedFields.put(gap.offset, field);
                    if (gap.size <= fieldSize) continue;
                    this.addFieldGap(gap.offset + fieldSize, gap.offset + gap.size, gaps);
                    continue;
                }
                linkedFields.append(fieldOffset, field);
                fieldOffset += fieldSize;
            }
            return linkedFields;
        }

        private void addFieldGap(int gapStart, int gapEnd, @Nonnull PriorityQueue<FieldGap> gaps) {
            int offset = gapStart;
            while (offset < gapEnd) {
                int remaining = gapEnd - offset;
                if (remaining >= 4 && offset % 4 == 0) {
                    gaps.add(FieldGap.newFieldGap(offset, 4, ClassProto.this.classPath.oatVersion));
                    offset += 4;
                    continue;
                }
                if (remaining >= 2 && offset % 2 == 0) {
                    gaps.add(FieldGap.newFieldGap(offset, 2, ClassProto.this.classPath.oatVersion));
                    offset += 2;
                    continue;
                }
                gaps.add(FieldGap.newFieldGap(offset, 1, ClassProto.this.classPath.oatVersion));
                ++offset;
            }
        }

        @Nonnull
        private ArrayList<Field> getSortedInstanceFields(@Nonnull ClassDef classDef) {
            ArrayList fields = (ArrayList)IteratorUtils.toList(classDef.getInstanceFields());
            Collections.sort(fields, new Comparator<Field>(){

                @Override
                public int compare(Field field1, Field field2) {
                    int result = Integer.compare(this.getFieldSortOrder(field1), this.getFieldSortOrder(field2));
                    if (result != 0) {
                        return result;
                    }
                    result = field1.getName().compareTo(field2.getName());
                    if (result != 0) {
                        return result;
                    }
                    return field1.getType().compareTo(field2.getType());
                }
            });
            return fields;
        }

        private int getFieldSortOrder(@Nonnull FieldReference field) {
            switch (field.getType().charAt(0)) {
                case 'L': 
                case '[': {
                    return 0;
                }
                case 'J': {
                    return 1;
                }
                case 'D': {
                    return 2;
                }
                case 'I': {
                    return 3;
                }
                case 'F': {
                    return 4;
                }
                case 'C': {
                    return 5;
                }
                case 'S': {
                    return 6;
                }
                case 'Z': {
                    return 7;
                }
                case 'B': {
                    return 8;
                }
            }
            throw new ExceptionWithContext("Invalid field type: %s", field.getType());
        }

        private int getFieldSize(@Nonnull FieldReference field) {
            return ClassProto.getTypeSize(field.getType().charAt(0));
        }
    });
    @Nonnull
    private final Supplier<List<Method>> preDefaultMethodVtableSupplier = MemoizingSupplier.memoize(new Supplier<List<Method>>(){

        @Override
        public List<Method> get() {
            String superclassType;
            ArrayList<Method> vtable = new ArrayList<Method>();
            try {
                superclassType = ClassProto.this.getSuperclass();
            }
            catch (UnresolvedClassException ex2) {
                vtable.addAll(((ClassProto)ClassProto.this.classPath.getClass("Ljava/lang/Object;")).getVtable());
                ClassProto.this.vtableFullyResolved = false;
                return vtable;
            }
            if (superclassType != null) {
                ClassProto superclass = (ClassProto)ClassProto.this.classPath.getClass(superclassType);
                vtable.addAll(superclass.getVtable());
                if (!superclass.vtableFullyResolved) {
                    ClassProto.this.vtableFullyResolved = false;
                    return vtable;
                }
            }
            if (!ClassProto.this.isInterface()) {
                ClassProto.this.addToVtable(ClassProto.this.getClassDef().getVirtualMethods(), vtable, true, true);
                Iterable<ClassDef> interfaces = ClassProto.this.getDirectInterfaces();
                for (ClassDef interfaceDef : interfaces) {
                    ArrayList<ReparentedMethod> interfaceMethods = new ArrayList<ReparentedMethod>();
                    for (Method method : interfaceDef.getVirtualMethods()) {
                        interfaceMethods.add(new ReparentedMethod(method, ClassProto.this.type));
                    }
                    ClassProto.this.addToVtable(interfaceMethods, vtable, false, true);
                }
            }
            return vtable;
        }
    });
    @Nonnull
    private final Supplier<List<Method>> buggyPostDefaultMethodVtableSupplier = MemoizingSupplier.memoize(new Supplier<List<Method>>(){

        @Override
        public List<Method> get() {
            String superclassType;
            ArrayList<Method> vtable = new ArrayList<Method>();
            try {
                superclassType = ClassProto.this.getSuperclass();
            }
            catch (UnresolvedClassException ex2) {
                vtable.addAll(((ClassProto)ClassProto.this.classPath.getClass("Ljava/lang/Object;")).getVtable());
                ClassProto.this.vtableFullyResolved = false;
                return vtable;
            }
            if (superclassType != null) {
                ClassProto superclass = (ClassProto)ClassProto.this.classPath.getClass(superclassType);
                vtable.addAll(superclass.getVtable());
                if (!superclass.vtableFullyResolved) {
                    ClassProto.this.vtableFullyResolved = false;
                    return vtable;
                }
            }
            if (!ClassProto.this.isInterface()) {
                ClassProto.this.addToVtable(ClassProto.this.getClassDef().getVirtualMethods(), vtable, true, true);
                ArrayList<String> interfaces = new ArrayList<String>(ClassProto.this.getInterfaces().keySet());
                ArrayList<Method> defaultMethods = new ArrayList<Method>();
                ArrayList<Method> defaultConflictMethods = new ArrayList<Method>();
                ArrayList<Method> mirandaMethods = new ArrayList<Method>();
                final HashMap<Method, Integer> methodOrder = new HashMap<Method, Integer>();
                for (int i11 = interfaces.size() - 1; i11 >= 0; --i11) {
                    String interfaceType = (String)interfaces.get(i11);
                    ClassDef interfaceDef = ClassProto.this.classPath.getClassDef(interfaceType);
                    for (Method method : interfaceDef.getVirtualMethods()) {
                        int vtableIndex = ClassProto.this.findMethodIndexInVtableReverse(vtable, method);
                        Method oldVtableMethod = null;
                        if (vtableIndex >= 0) {
                            oldVtableMethod = (Method)vtable.get(vtableIndex);
                        }
                        for (int j11 = 0; j11 < vtable.size(); ++j11) {
                            Method candidate = (Method)vtable.get(j11);
                            if (!MethodUtil.methodSignaturesMatch(candidate, method) || ClassProto.this.classPath.shouldCheckPackagePrivateAccess() && !AnalyzedMethodUtil.canAccess(ClassProto.this, candidate, true, false, false) || !ClassProto.this.interfaceMethodOverrides(method, candidate)) continue;
                            vtable.set(j11, method);
                        }
                        if (vtableIndex >= 0 && !ClassProto.this.isOverridableByDefaultMethod((Method)vtable.get(vtableIndex))) continue;
                        int defaultMethodIndex = ClassProto.this.findMethodIndexInVtable(defaultMethods, method);
                        if (defaultMethodIndex >= 0) {
                            ClassProto existingInterface;
                            if (AccessFlags.ABSTRACT.isSet(method.getAccessFlags()) || (existingInterface = (ClassProto)ClassProto.this.classPath.getClass(((Method)defaultMethods.get(defaultMethodIndex)).getDefiningClass())).implementsInterface(method.getDefiningClass())) continue;
                            Method removedMethod = (Method)defaultMethods.remove(defaultMethodIndex);
                            defaultConflictMethods.add(removedMethod);
                            continue;
                        }
                        int defaultConflictMethodIndex = ClassProto.this.findMethodIndexInVtable(defaultConflictMethods, method);
                        if (defaultConflictMethodIndex >= 0) continue;
                        int mirandaMethodIndex = ClassProto.this.findMethodIndexInVtable(mirandaMethods, method);
                        if (mirandaMethodIndex >= 0) {
                            ClassProto existingInterface;
                            if (AccessFlags.ABSTRACT.isSet(method.getAccessFlags()) || (existingInterface = (ClassProto)ClassProto.this.classPath.getClass(((Method)mirandaMethods.get(mirandaMethodIndex)).getDefiningClass())).implementsInterface(method.getDefiningClass())) continue;
                            Method oldMethod = (Method)mirandaMethods.remove(mirandaMethodIndex);
                            int methodOrderValue = (Integer)methodOrder.get(oldMethod);
                            methodOrder.put(method, methodOrderValue);
                            defaultMethods.add(method);
                            continue;
                        }
                        if (!AccessFlags.ABSTRACT.isSet(method.getAccessFlags())) {
                            if (oldVtableMethod != null && !ClassProto.this.interfaceMethodOverrides(method, oldVtableMethod)) continue;
                            defaultMethods.add(method);
                            methodOrder.put(method, methodOrder.size());
                            continue;
                        }
                        if (oldVtableMethod != null) continue;
                        mirandaMethods.add(method);
                        methodOrder.put(method, methodOrder.size());
                    }
                }
                Comparator<MethodReference> comparator = new Comparator<MethodReference>(){

                    @Override
                    public int compare(MethodReference o12, MethodReference o22) {
                        return Integer.compare((Integer)methodOrder.get(o12), (Integer)methodOrder.get(o22));
                    }
                };
                Collections.sort(mirandaMethods, comparator);
                Collections.sort(defaultMethods, comparator);
                Collections.sort(defaultConflictMethods, comparator);
                vtable.addAll(mirandaMethods);
                vtable.addAll(defaultMethods);
                vtable.addAll(defaultConflictMethods);
            }
            return vtable;
        }
    });
    @Nonnull
    private final Supplier<List<Method>> postDefaultMethodVtableSupplier = MemoizingSupplier.memoize(new Supplier<List<Method>>(){

        @Override
        public List<Method> get() {
            String superclassType;
            ArrayList<Method> vtable = new ArrayList<Method>();
            try {
                superclassType = ClassProto.this.getSuperclass();
            }
            catch (UnresolvedClassException ex2) {
                vtable.addAll(((ClassProto)ClassProto.this.classPath.getClass("Ljava/lang/Object;")).getVtable());
                ClassProto.this.vtableFullyResolved = false;
                return vtable;
            }
            if (superclassType != null) {
                ClassProto superclass = (ClassProto)ClassProto.this.classPath.getClass(superclassType);
                vtable.addAll(superclass.getVtable());
                if (!superclass.vtableFullyResolved) {
                    ClassProto.this.vtableFullyResolved = false;
                    return vtable;
                }
            }
            if (!ClassProto.this.isInterface()) {
                ClassProto.this.addToVtable(ClassProto.this.getClassDef().getVirtualMethods(), vtable, true, true);
                List<ClassDef> interfaces = IteratorUtils.toList(ClassProto.this.getDirectInterfaces());
                Collections.reverse(interfaces);
                ArrayList<Method> defaultMethods = new ArrayList<Method>();
                ArrayList<Method> defaultConflictMethods = new ArrayList<Method>();
                ArrayList<Method> mirandaMethods = new ArrayList<Method>();
                final HashMap<Method, Integer> methodOrder = new HashMap<Method, Integer>();
                for (ClassDef interfaceDef : interfaces) {
                    for (Method method : interfaceDef.getVirtualMethods()) {
                        int vtableIndex = ClassProto.this.findMethodIndexInVtable(vtable, method);
                        if (vtableIndex >= 0) {
                            if (!ClassProto.this.interfaceMethodOverrides(method, (Method)vtable.get(vtableIndex))) continue;
                            vtable.set(vtableIndex, method);
                            continue;
                        }
                        int defaultMethodIndex = ClassProto.this.findMethodIndexInVtable(defaultMethods, method);
                        if (defaultMethodIndex >= 0) {
                            ClassProto existingInterface;
                            if (AccessFlags.ABSTRACT.isSet(method.getAccessFlags()) || (existingInterface = (ClassProto)ClassProto.this.classPath.getClass(((Method)defaultMethods.get(defaultMethodIndex)).getDefiningClass())).implementsInterface(method.getDefiningClass())) continue;
                            Method removedMethod = (Method)defaultMethods.remove(defaultMethodIndex);
                            defaultConflictMethods.add(removedMethod);
                            continue;
                        }
                        int defaultConflictMethodIndex = ClassProto.this.findMethodIndexInVtable(defaultConflictMethods, method);
                        if (defaultConflictMethodIndex >= 0) continue;
                        int mirandaMethodIndex = ClassProto.this.findMethodIndexInVtable(mirandaMethods, method);
                        if (mirandaMethodIndex >= 0) {
                            ClassProto existingInterface;
                            if (AccessFlags.ABSTRACT.isSet(method.getAccessFlags()) || (existingInterface = (ClassProto)ClassProto.this.classPath.getClass(((Method)mirandaMethods.get(mirandaMethodIndex)).getDefiningClass())).implementsInterface(method.getDefiningClass())) continue;
                            Method oldMethod = (Method)mirandaMethods.remove(mirandaMethodIndex);
                            int methodOrderValue = (Integer)methodOrder.get(oldMethod);
                            methodOrder.put(method, methodOrderValue);
                            defaultMethods.add(method);
                            continue;
                        }
                        if (!AccessFlags.ABSTRACT.isSet(method.getAccessFlags())) {
                            defaultMethods.add(method);
                            methodOrder.put(method, methodOrder.size());
                            continue;
                        }
                        mirandaMethods.add(method);
                        methodOrder.put(method, methodOrder.size());
                    }
                }
                Comparator<MethodReference> comparator = new Comparator<MethodReference>(){

                    @Override
                    public int compare(MethodReference o12, MethodReference o22) {
                        return Integer.compare((Integer)methodOrder.get(o12), (Integer)methodOrder.get(o22));
                    }
                };
                Collections.sort(defaultMethods, comparator);
                Collections.sort(defaultConflictMethods, comparator);
                Collections.sort(mirandaMethods, comparator);
                ClassProto.this.addToVtable(defaultMethods, vtable, false, false);
                ClassProto.this.addToVtable(defaultConflictMethods, vtable, false, false);
                ClassProto.this.addToVtable(mirandaMethods, vtable, false, false);
            }
            return vtable;
        }
    });

    public ClassProto(@Nonnull ClassPath classPath, @Nonnull String type) {
        if (type.charAt(0) != 'L') {
            throw new ExceptionWithContext("Cannot construct ClassProto for non reference type: %s", type);
        }
        this.classPath = classPath;
        this.type = type;
    }

    public String toString() {
        return this.type;
    }

    @Override
    @Nonnull
    public ClassPath getClassPath() {
        return this.classPath;
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type;
    }

    @Nonnull
    public ClassDef getClassDef() {
        return this.classDefSupplier.get();
    }

    @Override
    public boolean isInterface() {
        ClassDef classDef = this.getClassDef();
        return (classDef.getAccessFlags() & AccessFlags.INTERFACE.getValue()) != 0;
    }

    @Nonnull
    protected LinkedHashMap<String, ClassDef> getInterfaces() {
        if (!this.classPath.isArt() || this.classPath.oatVersion < 72) {
            return this.preDefaultMethodInterfaceSupplier.get();
        }
        return this.postDefaultMethodInterfaceSupplier.get();
    }

    @Nonnull
    protected Set<String> getUnresolvedInterfaces() {
        if (this.unresolvedInterfaces == null) {
            return Collections.emptySet();
        }
        return this.unresolvedInterfaces;
    }

    @Nonnull
    protected Iterable<ClassDef> getDirectInterfaces() {
        AbstractIterator<ClassDef> directInterfaces = IteratorUtils.filter(this.getInterfaces().values(), new Predicate<ClassDef>(){

            @Override
            public boolean test(@Nullable ClassDef input) {
                return input != null;
            }
        });
        if (!this.interfacesFullyResolved) {
            throw new UnresolvedClassException("Interfaces for class %s not fully resolved: %s", this.getType(), StringUtils.join(this.getUnresolvedInterfaces(), ","));
        }
        return directInterfaces;
    }

    @Override
    public boolean implementsInterface(@Nonnull String iface) {
        if (this.getInterfaces().containsKey(iface)) {
            return true;
        }
        if (!this.interfacesFullyResolved) {
            throw new UnresolvedClassException("Interfaces for class %s not fully resolved", this.getType());
        }
        return false;
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return this.getClassDef().getSuperclass();
    }

    private boolean checkInterface(@Nonnull ClassProto other) {
        block6: {
            boolean isResolved = true;
            boolean isInterface = true;
            try {
                isInterface = this.isInterface();
            }
            catch (UnresolvedClassException ex2) {
                isResolved = false;
            }
            if (isInterface) {
                try {
                    if (other.implementsInterface(this.getType())) {
                        return true;
                    }
                }
                catch (UnresolvedClassException ex3) {
                    if (!isResolved) break block6;
                    throw ex3;
                }
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public TypeProto getCommonSuperclass(@Nonnull TypeProto other) {
        if (!(other instanceof ClassProto)) {
            return other.getCommonSuperclass(this);
        }
        if (this == other || this.getType().equals(other.getType())) {
            return this;
        }
        if (this.getType().equals("Ljava/lang/Object;")) {
            return this;
        }
        if (other.getType().equals("Ljava/lang/Object;")) {
            return other;
        }
        boolean gotException = false;
        try {
            if (this.checkInterface((ClassProto)other)) {
                return this;
            }
        }
        catch (UnresolvedClassException ex2) {
            gotException = true;
        }
        try {
            if (((ClassProto)other).checkInterface(this)) {
                return other;
            }
        }
        catch (UnresolvedClassException ex3) {
            gotException = true;
        }
        if (gotException) {
            return this.classPath.getUnknownClass();
        }
        ArrayList<ClassProto> thisChain = new ArrayList<ClassProto>();
        thisChain.add(this);
        IteratorUtils.addAll(thisChain, TypeProtoUtils.getSuperclassChain(this).iterator());
        ArrayList<TypeProto> otherChain = new ArrayList<TypeProto>();
        otherChain.add(other);
        IteratorUtils.addAll(otherChain, TypeProtoUtils.getSuperclassChain(other).iterator());
        Collections.reverse(thisChain);
        Collections.reverse(otherChain);
        for (int i11 = Math.min(thisChain.size(), otherChain.size()) - 1; i11 >= 0; --i11) {
            TypeProto typeProto = (TypeProto)thisChain.get(i11);
            if (!typeProto.getType().equals(((TypeProto)otherChain.get(i11)).getType())) continue;
            return typeProto;
        }
        return this.classPath.getUnknownClass();
    }

    @Override
    @Nullable
    public FieldReference getFieldByOffset(int fieldOffset) {
        if (this.getInstanceFields().size() == 0) {
            return null;
        }
        return this.getInstanceFields().get(fieldOffset);
    }

    @Override
    @Nullable
    public Method getMethodByVtableIndex(int vtableIndex) {
        List<Method> vtable = this.getVtable();
        if (vtableIndex < 0 || vtableIndex >= vtable.size()) {
            return null;
        }
        return vtable.get(vtableIndex);
    }

    @Override
    public int findMethodIndexInVtable(@Nonnull MethodReference method) {
        return this.findMethodIndexInVtable(this.getVtable(), method);
    }

    private int findMethodIndexInVtable(@Nonnull List<Method> vtable, MethodReference method) {
        for (int i11 = 0; i11 < vtable.size(); ++i11) {
            Method candidate = vtable.get(i11);
            if (!MethodUtil.methodSignaturesMatch(candidate, method) || this.classPath.shouldCheckPackagePrivateAccess() && !AnalyzedMethodUtil.canAccess(this, candidate, true, false, false)) continue;
            return i11;
        }
        return -1;
    }

    private int findMethodIndexInVtableReverse(@Nonnull List<Method> vtable, MethodReference method) {
        for (int i11 = vtable.size() - 1; i11 >= 0; --i11) {
            Method candidate = vtable.get(i11);
            if (!MethodUtil.methodSignaturesMatch(candidate, method) || this.classPath.shouldCheckPackagePrivateAccess() && !AnalyzedMethodUtil.canAccess(this, candidate, true, false, false)) continue;
            return i11;
        }
        return -1;
    }

    @Nonnull
    public SparseArray<FieldReference> getInstanceFields() {
        if (this.classPath.isArt()) {
            return this.artInstanceFieldsSupplier.get();
        }
        return this.dalvikInstanceFieldsSupplier.get();
    }

    private int getNextFieldOffset() {
        SparseArray<FieldReference> instanceFields = this.getInstanceFields();
        if (instanceFields.size() == 0) {
            return this.classPath.isArt() ? 0 : 8;
        }
        int lastItemIndex = instanceFields.size() - 1;
        int fieldOffset = instanceFields.keyAt(lastItemIndex);
        FieldReference lastField = instanceFields.valueAt(lastItemIndex);
        if (this.classPath.isArt()) {
            return fieldOffset + ClassProto.getTypeSize(lastField.getType().charAt(0));
        }
        switch (lastField.getType().charAt(0)) {
            case 'D': 
            case 'J': {
                return fieldOffset + 8;
            }
        }
        return fieldOffset + 4;
    }

    private static int getTypeSize(char type) {
        switch (type) {
            case 'D': 
            case 'J': {
                return 8;
            }
            case 'F': 
            case 'I': 
            case 'L': 
            case '[': {
                return 4;
            }
            case 'C': 
            case 'S': {
                return 2;
            }
            case 'B': 
            case 'Z': {
                return 1;
            }
        }
        throw new ExceptionWithContext("Invalid type: %s", Character.valueOf(type));
    }

    @Nonnull
    public List<Method> getVtable() {
        if (!this.classPath.isArt() || this.classPath.oatVersion < 72) {
            return this.preDefaultMethodVtableSupplier.get();
        }
        if (this.classPath.oatVersion < 87) {
            return this.buggyPostDefaultMethodVtableSupplier.get();
        }
        return this.postDefaultMethodVtableSupplier.get();
    }

    private void addToVtable(@Nonnull Iterable<? extends Method> localMethods, @Nonnull List<Method> vtable, boolean replaceExisting, boolean sort) {
        if (sort) {
            ArrayList methods = (ArrayList)IteratorUtils.toList(localMethods);
            Collections.sort(methods);
            localMethods = methods;
        }
        for (Method virtualMethod : localMethods) {
            int vtableIndex = this.findMethodIndexInVtable(vtable, virtualMethod);
            if (vtableIndex >= 0) {
                if (!replaceExisting) continue;
                vtable.set(vtableIndex, virtualMethod);
                continue;
            }
            vtable.add(virtualMethod);
        }
    }

    private static byte getFieldType(@Nonnull FieldReference field) {
        switch (field.getType().charAt(0)) {
            case 'L': 
            case '[': {
                return 0;
            }
            case 'D': 
            case 'J': {
                return 1;
            }
        }
        return 2;
    }

    private boolean isOverridableByDefaultMethod(@Nonnull Method method) {
        ClassProto classProto = (ClassProto)this.classPath.getClass(method.getDefiningClass());
        return classProto.isInterface();
    }

    private boolean interfaceMethodOverrides(@Nonnull Method method, @Nonnull Method method2) {
        ClassProto classProto = (ClassProto)this.classPath.getClass(method2.getDefiningClass());
        if (classProto.isInterface()) {
            ClassProto targetClassProto = (ClassProto)this.classPath.getClass(method.getDefiningClass());
            return targetClassProto.implementsInterface(method2.getDefiningClass());
        }
        return false;
    }

    static class ReparentedMethod
    extends BaseMethodReference
    implements Method {
        private final Method method;
        private final String definingClass;

        public ReparentedMethod(Method method, String definingClass) {
            this.method = method;
            this.definingClass = definingClass;
        }

        @Override
        @Nonnull
        public String getDefiningClass() {
            return this.definingClass;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.method.getName();
        }

        @Override
        @Nonnull
        public List<? extends CharSequence> getParameterTypes() {
            return this.method.getParameterTypes();
        }

        @Override
        @Nonnull
        public String getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        @Nonnull
        public List<? extends MethodParameter> getParameters() {
            return this.method.getParameters();
        }

        @Override
        public int getAccessFlags() {
            return this.method.getAccessFlags();
        }

        @Override
        @Nonnull
        public Set<? extends Annotation> getAnnotations() {
            return this.method.getAnnotations();
        }

        @Override
        @Nonnull
        public Set<HiddenApiRestriction> getHiddenApiRestrictions() {
            return this.method.getHiddenApiRestrictions();
        }

        @Override
        @Nullable
        public MethodImplementation getImplementation() {
            return this.method.getImplementation();
        }
    }

    private static abstract class FieldGap
    implements Comparable<FieldGap> {
        public final int offset;
        public final int size;

        public static FieldGap newFieldGap(int offset, int size, int oatVersion) {
            if (oatVersion >= 67) {
                return new FieldGap(offset, size){

                    @Override
                    public int compareTo(@Nonnull FieldGap o11) {
                        int result = Integer.compare(o11.size, this.size);
                        if (result != 0) {
                            return result;
                        }
                        return Integer.compare(this.offset, o11.offset);
                    }
                };
            }
            return new FieldGap(offset, size){

                @Override
                public int compareTo(@Nonnull FieldGap o11) {
                    int result = Integer.compare(this.size, o11.size);
                    if (result != 0) {
                        return result;
                    }
                    return Integer.compare(o11.offset, this.offset);
                }
            };
        }

        private FieldGap(int offset, int size) {
            this.offset = offset;
            this.size = size;
        }
    }
}

