/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.raw;

import com.android.tools.smali.dexlib2.dexbacked.CDexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;
import com.android.tools.smali.dexlib2.dexbacked.DexReader;
import com.android.tools.smali.dexlib2.dexbacked.raw.SectionAnnotator;
import com.android.tools.smali.dexlib2.dexbacked.raw.util.DexAnnotator;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedMethodReference;
import javax.annotation.Nonnull;

public class CdexDebugOffsetTable {
    @Nonnull
    public static void annotate(@Nonnull DexAnnotator annotator, DexBuffer buffer) {
        DexReader<? extends DexBuffer> reader = buffer.readerAt(annotator.getCursor());
        SectionAnnotator debugInfoAnnotator = annotator.getAnnotator(8195);
        int methodCount = annotator.dexFile.getMethodSection().size();
        for (int methodIndex = 0; methodIndex < methodCount; methodIndex += 16) {
            annotator.annotate(0, "Offset chuck for methods %d-%d", methodIndex, Math.min(methodIndex + 16, methodCount));
            annotator.indent();
            int bitmask = reader.readUbyte() << 8;
            bitmask |= reader.readUbyte();
            StringBuilder sb2 = new StringBuilder();
            for (int i11 = 0; i11 < 16; ++i11) {
                sb2.append(bitmask >> i11 & 1);
            }
            annotator.annotate(2, "bitmask: 0b%s", sb2.reverse());
            int debugOffset = ((CDexBackedDexFile)annotator.dexFile).getDebugInfoBase();
            for (int i12 = 0; i12 < 16; ++i12) {
                if ((bitmask & 1) != 0) {
                    int offsetDelta = reader.readBigUleb128();
                    annotator.annotateTo(reader.getOffset(), "[method_id: %d]: offset_delta: %d  (offset=0x%x)", methodIndex + i12, offsetDelta, debugOffset += offsetDelta);
                    debugInfoAnnotator.setItemIdentity(debugOffset, ((DexBackedMethodReference)annotator.dexFile.getMethodSection().get(methodIndex + i12)).toString());
                }
                bitmask >>= 1;
            }
            annotator.deindent();
        }
    }
}

