/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.raw;

import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;
import com.android.tools.smali.dexlib2.util.AnnotatedBytes;
import javax.annotation.Nonnull;

public class CdexHeaderItem {
    private static final byte[] MAGIC_VALUE = new byte[]{99, 100, 101, 120, 0, 0, 0, 0};
    private static final int[] SUPPORTED_CDEX_VERSIONS = new int[]{1};
    public static final int FEATURE_FLAGS_OFFSET = 112;
    public static final int DEBUG_INFO_OFFSETS_POS_OFFSET = 116;
    public static final int DEBUG_INFO_OFFSETS_TABLE_OFFSET = 120;
    public static final int DEBUG_INFO_BASE = 124;

    public static boolean verifyMagic(byte[] buf, int offset) {
        int i11;
        if (buf.length - offset < 8) {
            return false;
        }
        for (i11 = 0; i11 < 4; ++i11) {
            if (buf[offset + i11] == MAGIC_VALUE[i11]) continue;
            return false;
        }
        for (i11 = 4; i11 < 7; ++i11) {
            if (buf[offset + i11] >= 48 && buf[offset + i11] <= 57) continue;
            return false;
        }
        return buf[offset + 7] == MAGIC_VALUE[7];
    }

    public static int getVersion(byte[] buf, int offset) {
        if (!CdexHeaderItem.verifyMagic(buf, offset)) {
            return -1;
        }
        return CdexHeaderItem.getVersionUnchecked(buf, offset);
    }

    private static int getVersionUnchecked(byte[] buf, int offset) {
        int version = (buf[offset + 4] - 48) * 100;
        version += (buf[offset + 5] - 48) * 10;
        return version += buf[offset + 6] - 48;
    }

    public static boolean isSupportedCdexVersion(int version) {
        for (int i11 = 0; i11 < SUPPORTED_CDEX_VERSIONS.length; ++i11) {
            if (SUPPORTED_CDEX_VERSIONS[i11] != version) continue;
            return true;
        }
        return false;
    }

    public static void annotateCdexHeaderFields(@Nonnull AnnotatedBytes out, DexBuffer buf) {
        out.annotate(4, "feature_flags: 0x%x", buf.readInt(out.getCursor()));
        out.annotate(4, "debug_info_offsets_pos: 0x%x", buf.readInt(out.getCursor()));
        out.annotate(4, "debug_info_offsets_table_offset: 0x%x", buf.readInt(out.getCursor()));
        out.annotate(4, "debug_info_base: 0x%x", buf.readInt(out.getCursor()));
    }
}

