/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.raw;

import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.raw.MapItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.util.DexAnnotator;
import com.android.tools.smali.dexlib2.util.AlignmentUtils;
import com.android.tools.smali.dexlib2.util.AnnotatedBytes;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class SectionAnnotator {
    @Nonnull
    public final DexAnnotator annotator;
    @Nonnull
    public final DexBackedDexFile dexFile;
    public final int itemType;
    public final int sectionOffset;
    public final int itemCount;
    protected Map<Integer, String> itemIdentities = new HashMap<Integer, String>();

    public SectionAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        this.annotator = annotator;
        this.dexFile = annotator.dexFile;
        this.itemType = mapItem.getType();
        this.sectionOffset = mapItem.getType() >= 4096 ? mapItem.getOffset() + this.dexFile.getBaseDataOffset() : mapItem.getOffset();
        this.itemCount = mapItem.getItemCount();
    }

    @Nonnull
    public abstract String getItemName();

    protected abstract void annotateItem(@Nonnull AnnotatedBytes var1, int var2, @Nullable String var3);

    public void annotateSection(@Nonnull AnnotatedBytes out) {
        out.moveTo(this.sectionOffset);
        this.annotateSectionInner(out, this.itemCount);
    }

    protected int getItemOffset(int itemIndex, int currentOffset) {
        return AlignmentUtils.alignOffset(currentOffset, this.getItemAlignment());
    }

    protected void annotateSectionInner(@Nonnull AnnotatedBytes out, int itemCount) {
        String itemName = this.getItemName();
        if (itemCount > 0) {
            out.annotate(0, "", new Object[0]);
            out.annotate(0, "-----------------------------", new Object[0]);
            out.annotate(0, "%s section", itemName);
            out.annotate(0, "-----------------------------", new Object[0]);
            out.annotate(0, "", new Object[0]);
            for (int i11 = 0; i11 < itemCount; ++i11) {
                out.moveTo(this.getItemOffset(i11, out.getCursor()));
                String itemIdentity = this.getItemIdentity(out.getCursor());
                if (itemIdentity != null) {
                    out.annotate(0, "[%d] %s: %s", i11, itemName, itemIdentity);
                } else {
                    out.annotate(0, "[%d] %s", i11, itemName);
                }
                out.indent();
                this.annotateItem(out, i11, itemIdentity);
                out.deindent();
            }
        }
    }

    @Nullable
    private String getItemIdentity(int itemOffset) {
        return this.itemIdentities.get(itemOffset);
    }

    public void setItemIdentity(int itemOffset, String identity) {
        this.itemIdentities.put(itemOffset + this.dexFile.getBaseDataOffset(), identity);
    }

    public int getItemAlignment() {
        return 1;
    }
}

