/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.raw;

import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.raw.MapItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.SectionAnnotator;
import com.android.tools.smali.dexlib2.dexbacked.raw.TypeIdItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.util.DexAnnotator;
import com.android.tools.smali.dexlib2.util.AnnotatedBytes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TypeListItem {
    public static final int SIZE_OFFSET = 0;
    public static final int LIST_OFFSET = 4;

    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                return "type_list";
            }

            @Override
            protected void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                int size = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                out.annotate(4, "size: %d", size);
                for (int i11 = 0; i11 < size; ++i11) {
                    int typeIndex = this.dexFile.getBuffer().readUshort(out.getCursor());
                    out.annotate(2, TypeIdItem.getReferenceAnnotation(this.dexFile, typeIndex), new Object[0]);
                }
            }

            @Override
            public int getItemAlignment() {
                return 4;
            }
        };
    }

    @Nonnull
    public static String getReferenceAnnotation(@Nonnull DexBackedDexFile dexFile, int typeListOffset) {
        if (typeListOffset == 0) {
            return "type_list_item[NO_OFFSET]";
        }
        try {
            String typeList = TypeListItem.asString(dexFile, typeListOffset);
            return String.format("type_list_item[0x%x]: %s", typeListOffset, typeList);
        }
        catch (Exception ex2) {
            ex2.printStackTrace(System.err);
            return String.format("type_list_item[0x%x]", typeListOffset);
        }
    }

    @Nonnull
    public static String asString(@Nonnull DexBackedDexFile dexFile, int typeListOffset) {
        if (typeListOffset == 0) {
            return "";
        }
        StringBuilder sb2 = new StringBuilder();
        int size = dexFile.getDataBuffer().readSmallUint(typeListOffset);
        for (int i11 = 0; i11 < size; ++i11) {
            int typeIndex = dexFile.getDataBuffer().readUshort(typeListOffset + 4 + i11 * 2);
            String type = (String)dexFile.getTypeSection().get(typeIndex);
            sb2.append(type);
        }
        return sb2.toString();
    }
}

