/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.reference;

import com.android.tools.smali.dexlib2.base.reference.BaseMethodHandleReference;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedFieldReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedMethodReference;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.util.ExceptionWithContext;
import javax.annotation.Nonnull;

public class DexBackedMethodHandleReference
extends BaseMethodHandleReference {
    @Nonnull
    public final DexBackedDexFile dexFile;
    public final int methodHandleIndex;
    public final int methodHandleOffset;

    public DexBackedMethodHandleReference(DexBackedDexFile dexFile, int methodHandleIndex) {
        this.dexFile = dexFile;
        this.methodHandleIndex = methodHandleIndex;
        this.methodHandleOffset = dexFile.getMethodHandleSection().getOffset(methodHandleIndex);
    }

    @Override
    public int getMethodHandleType() {
        return this.dexFile.getBuffer().readUshort(this.methodHandleOffset + 0);
    }

    @Override
    @Nonnull
    public Reference getMemberReference() {
        int memberIndex = this.dexFile.getBuffer().readUshort(this.methodHandleOffset + 4);
        switch (this.getMethodHandleType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new DexBackedFieldReference(this.dexFile, memberIndex);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new DexBackedMethodReference(this.dexFile, memberIndex);
            }
        }
        throw new ExceptionWithContext("Invalid method handle type: %d", this.getMethodHandleType());
    }

    @Override
    public void validateReference() throws Reference.InvalidReferenceException {
        if (this.methodHandleIndex < 0 || this.methodHandleIndex >= this.dexFile.getMethodHandleSection().size()) {
            throw new Reference.InvalidReferenceException("methodhandle@" + this.methodHandleIndex);
        }
        try {
            this.getMemberReference();
        }
        catch (ExceptionWithContext ex2) {
            throw new Reference.InvalidReferenceException("methodhandle@" + this.methodHandleIndex, ex2);
        }
    }
}

