/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.util;

import com.android.tools.smali.util.ExceptionWithContext;
import com.android.tools.smali.util.Hex;
import com.android.tools.smali.util.StringUtils;
import com.android.tools.smali.util.TwoColumnOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AnnotatedBytes {
    @Nonnull
    private TreeMap<Integer, AnnotationEndpoint> annotatations = new TreeMap();
    private int cursor;
    private int indentLevel;
    private int outputWidth;
    private int hexCols = 8;
    private int startLimit = -1;
    private int endLimit = -1;

    public AnnotatedBytes(int width) {
        this.outputWidth = width;
    }

    public void moveTo(int offset) {
        this.cursor = offset;
    }

    public void moveBy(int offset) {
        this.cursor += offset;
    }

    public void annotateTo(int offset, @Nonnull String msg, Object ... formatArgs) {
        this.annotate(offset - this.cursor, msg, formatArgs);
    }

    public void annotate(int length, @Nonnull String msg, Object ... formatArgs) {
        Map.Entry<Integer, AnnotationEndpoint> nextEntry;
        AnnotationItem existingRangeAnnotation;
        if (this.startLimit != -1 && this.endLimit != -1 && (this.cursor < this.startLimit || this.cursor >= this.endLimit)) {
            throw new ExceptionWithContext("Annotating outside the parent bounds", new Object[0]);
        }
        String formattedMsg = formatArgs != null && formatArgs.length > 0 ? String.format(msg, formatArgs) : msg;
        int exclusiveEndOffset = this.cursor + length;
        AnnotationEndpoint endPoint = null;
        AnnotationEndpoint startPoint = this.annotatations.get(this.cursor);
        if (startPoint == null) {
            Map.Entry<Integer, AnnotationEndpoint> previousEntry = this.annotatations.lowerEntry(this.cursor);
            if (previousEntry != null) {
                AnnotationEndpoint previousAnnotations = previousEntry.getValue();
                AnnotationItem previousRangeAnnotation = previousAnnotations.rangeAnnotation;
                if (previousRangeAnnotation != null) {
                    throw new ExceptionWithContext("Cannot add annotation %s, due to existing annotation %s", this.formatAnnotation(this.cursor, this.cursor + length, formattedMsg), this.formatAnnotation(previousEntry.getKey(), previousRangeAnnotation.annotation));
                }
            }
        } else if (length > 0 && (existingRangeAnnotation = startPoint.rangeAnnotation) != null) {
            throw new ExceptionWithContext("Cannot add annotation %s, due to existing annotation %s", this.formatAnnotation(this.cursor, this.cursor + length, formattedMsg), this.formatAnnotation(this.cursor, existingRangeAnnotation.annotation));
        }
        if (length > 0 && (nextEntry = this.annotatations.higherEntry(this.cursor)) != null) {
            int nextKey = nextEntry.getKey();
            if (nextKey < exclusiveEndOffset) {
                AnnotationEndpoint nextEndpoint = nextEntry.getValue();
                AnnotationItem nextRangeAnnotation = nextEndpoint.rangeAnnotation;
                if (nextRangeAnnotation != null) {
                    throw new ExceptionWithContext("Cannot add annotation %s, due to existing annotation %s", this.formatAnnotation(this.cursor, this.cursor + length, formattedMsg), this.formatAnnotation(nextKey, nextRangeAnnotation.annotation));
                }
                if (nextEndpoint.pointAnnotations.size() > 0) {
                    throw new ExceptionWithContext("Cannot add annotation %s, due to existing annotation %s", this.formatAnnotation(this.cursor, this.cursor + length, formattedMsg), this.formatAnnotation(nextKey, nextKey, nextEndpoint.pointAnnotations.get((int)0).annotation));
                }
                throw new ExceptionWithContext("Cannot add annotation %s, due to existing annotation endpoint at %d", this.formatAnnotation(this.cursor, this.cursor + length, formattedMsg), nextKey);
            }
            if (nextKey == exclusiveEndOffset) {
                endPoint = nextEntry.getValue();
            }
        }
        if (startPoint == null) {
            startPoint = new AnnotationEndpoint();
            this.annotatations.put(this.cursor, startPoint);
        }
        if (length == 0) {
            startPoint.pointAnnotations.add(new AnnotationItem(this.indentLevel, formattedMsg));
        } else {
            startPoint.rangeAnnotation = new AnnotationItem(this.indentLevel, formattedMsg);
            if (endPoint == null) {
                endPoint = new AnnotationEndpoint();
                this.annotatations.put(exclusiveEndOffset, endPoint);
            }
        }
        this.cursor += length;
    }

    private String formatAnnotation(int offset, String annotationMsg) {
        Integer endOffset = this.annotatations.higherKey(offset);
        return this.formatAnnotation(offset, endOffset, annotationMsg);
    }

    private String formatAnnotation(int offset, Integer endOffset, String annotationMsg) {
        if (endOffset != null) {
            return String.format("[0x%x, 0x%x) \"%s\"", offset, endOffset, annotationMsg);
        }
        return String.format("[0x%x, ) \"%s\"", offset, annotationMsg);
    }

    public void indent() {
        ++this.indentLevel;
    }

    public void deindent() {
        --this.indentLevel;
        if (this.indentLevel < 0) {
            this.indentLevel = 0;
        }
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getAnnotationWidth() {
        int leftWidth = 8 + this.hexCols * 2 + this.hexCols / 2;
        return this.outputWidth - leftWidth;
    }

    public void writeAnnotations(Writer out, byte[] data, int offset) throws IOException {
        int rightWidth = this.getAnnotationWidth();
        int leftWidth = this.outputWidth - rightWidth - 1;
        String padding = StringUtils.repeat(" ", 1000);
        TwoColumnOutput twoc = new TwoColumnOutput(out, leftWidth, rightWidth, "|");
        Integer[] keys = new Integer[this.annotatations.size()];
        keys = this.annotatations.keySet().toArray(keys);
        AnnotationEndpoint[] values = new AnnotationEndpoint[this.annotatations.size()];
        values = this.annotatations.values().toArray(values);
        for (int i11 = 0; i11 < keys.length - 1; ++i11) {
            String right;
            int rangeStart = keys[i11];
            int rangeEnd = keys[i11 + 1];
            AnnotationEndpoint annotations = values[i11];
            for (AnnotationItem pointAnnotation : annotations.pointAnnotations) {
                String paddingSub = padding.substring(0, pointAnnotation.indentLevel * 2);
                twoc.write("", paddingSub + pointAnnotation.annotation);
            }
            AnnotationItem rangeAnnotation = annotations.rangeAnnotation;
            if (rangeAnnotation != null) {
                right = padding.substring(0, rangeAnnotation.indentLevel * 2);
                right = right + rangeAnnotation.annotation;
            } else {
                right = "";
            }
            String left = Hex.dump(data, rangeStart + offset, rangeEnd - rangeStart, rangeStart + offset, this.hexCols, 6);
            twoc.write(left, right);
        }
        int lastKey = keys[keys.length - 1];
        if (lastKey < data.length) {
            String left = Hex.dump(data, lastKey + offset, data.length - offset - lastKey, lastKey + offset, this.hexCols, 6);
            twoc.write(left, "");
        }
    }

    public void setLimit(int start, int end) {
        this.startLimit = start;
        this.endLimit = end;
    }

    public void clearLimit() {
        this.startLimit = -1;
        this.endLimit = -1;
    }

    private static class AnnotationItem {
        public final int indentLevel;
        public final String annotation;

        public AnnotationItem(int indentLevel, String annotation) {
            this.indentLevel = indentLevel;
            this.annotation = annotation;
        }
    }

    private static class AnnotationEndpoint {
        @Nonnull
        public final List<AnnotationItem> pointAnnotations = new ArrayList<AnnotationItem>();
        @Nullable
        public AnnotationItem rangeAnnotation = null;

        private AnnotationEndpoint() {
        }
    }
}

