/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.util;

import com.android.tools.smali.dexlib2.iface.instruction.Instruction;
import com.android.tools.smali.util.ExceptionWithContext;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class InstructionOffsetMap {
    @Nonnull
    private final int[] instructionCodeOffsets;

    public InstructionOffsetMap(@Nonnull List<? extends Instruction> instructions) {
        this.instructionCodeOffsets = new int[instructions.size()];
        int codeOffset = 0;
        for (int i11 = 0; i11 < instructions.size(); ++i11) {
            this.instructionCodeOffsets[i11] = codeOffset;
            codeOffset += instructions.get(i11).getCodeUnits();
        }
    }

    public int getInstructionIndexAtCodeOffset(int codeOffset) {
        return this.getInstructionIndexAtCodeOffset(codeOffset, true);
    }

    public int getInstructionIndexAtCodeOffset(int codeOffset, boolean exact) {
        int index = Arrays.binarySearch(this.instructionCodeOffsets, codeOffset);
        if (index < 0) {
            if (exact) {
                throw new InvalidInstructionOffset(codeOffset);
            }
            return ~index - 1;
        }
        return index;
    }

    public int getInstructionCodeOffset(int index) {
        if (index < 0 || index >= this.instructionCodeOffsets.length) {
            throw new InvalidInstructionIndex(index);
        }
        return this.instructionCodeOffsets[index];
    }

    public static class InvalidInstructionIndex
    extends ExceptionWithContext {
        private final int instructionIndex;

        public InvalidInstructionIndex(int instructionIndex) {
            super("Instruction index out of bounds: %d", instructionIndex);
            this.instructionIndex = instructionIndex;
        }

        public int getInstructionIndex() {
            return this.instructionIndex;
        }
    }

    public static class InvalidInstructionOffset
    extends ExceptionWithContext {
        private final int instructionOffset;

        public InvalidInstructionOffset(int instructionOffset) {
            super("No instruction at offset %d", instructionOffset);
            this.instructionOffset = instructionOffset;
        }

        public int getInstructionOffset() {
            return this.instructionOffset;
        }
    }
}

