/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.builder;

import com.android.tools.smali.dexlib2.writer.TypeSection;
import com.android.tools.smali.dexlib2.writer.builder.BaseBuilderPool;
import com.android.tools.smali.dexlib2.writer.builder.BuilderMapEntryCollection;
import com.android.tools.smali.dexlib2.writer.builder.BuilderStringPool;
import com.android.tools.smali.dexlib2.writer.builder.BuilderStringReference;
import com.android.tools.smali.dexlib2.writer.builder.BuilderTypeReference;
import com.android.tools.smali.dexlib2.writer.builder.DexBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class BuilderTypePool
extends BaseBuilderPool
implements TypeSection<BuilderStringReference, BuilderTypeReference, BuilderTypeReference> {
    @Nonnull
    private final ConcurrentMap<String, BuilderTypeReference> internedItems = new ConcurrentHashMap<String, BuilderTypeReference>();

    public BuilderTypePool(@Nonnull DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    @Nonnull
    public BuilderTypeReference internType(@Nonnull String type) {
        BuilderTypeReference ret = (BuilderTypeReference)this.internedItems.get(type);
        if (ret != null) {
            return ret;
        }
        BuilderStringReference stringRef = ((BuilderStringPool)this.dexBuilder.stringSection).internString(type);
        BuilderTypeReference typeReference = new BuilderTypeReference(stringRef);
        ret = this.internedItems.putIfAbsent(type, typeReference);
        return ret == null ? typeReference : ret;
    }

    @Nullable
    public BuilderTypeReference internNullableType(@Nullable String type) {
        if (type == null) {
            return null;
        }
        return this.internType(type);
    }

    @Override
    @Nonnull
    public BuilderStringReference getString(@Nonnull BuilderTypeReference key) {
        return key.stringReference;
    }

    @Override
    public int getNullableItemIndex(@Nullable BuilderTypeReference key) {
        return key == null ? -1 : key.index;
    }

    @Override
    public int getItemIndex(@Nonnull BuilderTypeReference key) {
        return key.getIndex();
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderTypeReference, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderTypeReference>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderTypeReference key) {
                return key.index;
            }

            @Override
            protected int setValue(@Nonnull BuilderTypeReference key, int value) {
                int prev = key.index;
                key.index = value;
                return prev;
            }
        };
    }

    @Override
    public int getItemCount() {
        return this.internedItems.size();
    }
}

