/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.pool;

import com.android.tools.smali.dexlib2.writer.TypeListSection;
import com.android.tools.smali.dexlib2.writer.pool.BaseNullableOffsetPool;
import com.android.tools.smali.dexlib2.writer.pool.DexPool;
import com.android.tools.smali.dexlib2.writer.pool.TypePool;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TypeListPool
extends BaseNullableOffsetPool<Key<? extends Collection<? extends CharSequence>>>
implements TypeListSection<CharSequence, Key<? extends Collection<? extends CharSequence>>> {
    public TypeListPool(@Nonnull DexPool dexPool) {
        super(dexPool);
    }

    public void intern(@Nonnull Collection<? extends CharSequence> types) {
        Key<Collection<? extends CharSequence>> key;
        Integer prev;
        if (types.size() > 0 && (prev = this.internedItems.put(key = new Key<Collection<? extends CharSequence>>(types), 0)) == null) {
            for (CharSequence charSequence : types) {
                ((TypePool)this.dexPool.typeSection).intern(charSequence);
            }
        }
    }

    @Override
    @Nonnull
    public Collection<? extends CharSequence> getTypes(Key<? extends Collection<? extends CharSequence>> typesKey) {
        if (typesKey == null) {
            return Collections.emptyList();
        }
        return typesKey.types;
    }

    @Override
    public int getNullableItemOffset(@Nullable Key<? extends Collection<? extends CharSequence>> key) {
        if (key == null || key.types.size() == 0) {
            return 0;
        }
        return super.getNullableItemOffset(key);
    }

    public static class Key<TypeCollection extends Collection<? extends CharSequence>>
    implements Comparable<Key<? extends Collection<? extends CharSequence>>> {
        @Nonnull
        TypeCollection types;

        public Key(@Nonnull TypeCollection types) {
            this.types = types;
        }

        public int hashCode() {
            int hashCode = 1;
            for (CharSequence type : this.types) {
                hashCode = hashCode * 31 + type.toString().hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object o11) {
            if (o11 instanceof Key) {
                Key other = (Key)o11;
                if (this.types.size() != other.types.size()) {
                    return false;
                }
                Iterator otherTypes = other.types.iterator();
                for (CharSequence type : this.types) {
                    if (type.toString().equals(((CharSequence)otherTypes.next()).toString())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb2 = new StringBuilder();
            for (CharSequence type : this.types) {
                sb2.append(type.toString());
            }
            return sb2.toString();
        }

        @Override
        public int compareTo(Key<? extends Collection<? extends CharSequence>> o11) {
            Iterator other = o11.types.iterator();
            for (CharSequence type : this.types) {
                if (!other.hasNext()) {
                    return 1;
                }
                int comparison = type.toString().compareTo(((CharSequence)other.next()).toString());
                if (comparison == 0) continue;
                return comparison;
            }
            if (other.hasNext()) {
                return -1;
            }
            return 0;
        }
    }
}

