/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

public final class Hex {
    private Hex() {
    }

    public static String u8(long v11) {
        char[] result = new char[16];
        for (int i11 = 0; i11 < 16; ++i11) {
            result[15 - i11] = Character.forDigit((int)v11 & 0xF, 16);
            v11 >>= 4;
        }
        return new String(result);
    }

    public static String u4(int v11) {
        char[] result = new char[8];
        for (int i11 = 0; i11 < 8; ++i11) {
            result[7 - i11] = Character.forDigit(v11 & 0xF, 16);
            v11 >>= 4;
        }
        return new String(result);
    }

    public static String u3(int v11) {
        char[] result = new char[6];
        for (int i11 = 0; i11 < 6; ++i11) {
            result[5 - i11] = Character.forDigit(v11 & 0xF, 16);
            v11 >>= 4;
        }
        return new String(result);
    }

    public static String u2(int v11) {
        char[] result = new char[4];
        for (int i11 = 0; i11 < 4; ++i11) {
            result[3 - i11] = Character.forDigit(v11 & 0xF, 16);
            v11 >>= 4;
        }
        return new String(result);
    }

    public static String u2or4(int v11) {
        if (v11 == (char)v11) {
            return Hex.u2(v11);
        }
        return Hex.u4(v11);
    }

    public static String u1(int v11) {
        char[] result = new char[2];
        for (int i11 = 0; i11 < 2; ++i11) {
            result[1 - i11] = Character.forDigit(v11 & 0xF, 16);
            v11 >>= 4;
        }
        return new String(result);
    }

    public static String uNibble(int v11) {
        char[] result = new char[]{Character.forDigit(v11 & 0xF, 16)};
        return new String(result);
    }

    public static String s8(long v11) {
        char[] result = new char[17];
        if (v11 < 0L) {
            result[0] = 45;
            v11 = -v11;
        } else {
            result[0] = 43;
        }
        for (int i11 = 0; i11 < 16; ++i11) {
            result[16 - i11] = Character.forDigit((int)v11 & 0xF, 16);
            v11 >>= 4;
        }
        return new String(result);
    }

    public static String s4(int v11) {
        char[] result = new char[9];
        if (v11 < 0) {
            result[0] = 45;
            v11 = -v11;
        } else {
            result[0] = 43;
        }
        for (int i11 = 0; i11 < 8; ++i11) {
            result[8 - i11] = Character.forDigit(v11 & 0xF, 16);
            v11 >>= 4;
        }
        return new String(result);
    }

    public static String s2(int v11) {
        char[] result = new char[5];
        if (v11 < 0) {
            result[0] = 45;
            v11 = -v11;
        } else {
            result[0] = 43;
        }
        for (int i11 = 0; i11 < 4; ++i11) {
            result[4 - i11] = Character.forDigit(v11 & 0xF, 16);
            v11 >>= 4;
        }
        return new String(result);
    }

    public static String s1(int v11) {
        char[] result = new char[3];
        if (v11 < 0) {
            result[0] = 45;
            v11 = -v11;
        } else {
            result[0] = 43;
        }
        for (int i11 = 0; i11 < 2; ++i11) {
            result[2 - i11] = Character.forDigit(v11 & 0xF, 16);
            v11 >>= 4;
        }
        return new String(result);
    }

    public static String dump(byte[] arr, int offset, int length, int outOffset, int bpl, int addressLength) {
        int end = offset + length;
        if ((offset | length | end) < 0 || end > arr.length) {
            throw new IndexOutOfBoundsException("arr.length " + arr.length + "; " + offset + "..!" + end);
        }
        if (outOffset < 0) {
            throw new IllegalArgumentException("outOffset < 0");
        }
        if (length == 0) {
            return "";
        }
        StringBuffer sb2 = new StringBuffer(length * 4 + 6);
        boolean bol = true;
        int col = 0;
        while (length > 0) {
            if (col == 0) {
                String astr;
                switch (addressLength) {
                    case 2: {
                        astr = Hex.u1(outOffset);
                        break;
                    }
                    case 4: {
                        astr = Hex.u2(outOffset);
                        break;
                    }
                    case 6: {
                        astr = Hex.u3(outOffset);
                        break;
                    }
                    default: {
                        astr = Hex.u4(outOffset);
                    }
                }
                sb2.append(astr);
                sb2.append(": ");
            } else if (!(col & true)) {
                sb2.append(' ');
            }
            sb2.append(Hex.u1(arr[offset]));
            ++outOffset;
            ++offset;
            if (++col == bpl) {
                sb2.append('\n');
                col = 0;
            }
            --length;
        }
        if (col != 0) {
            sb2.append('\n');
        }
        return sb2.toString();
    }
}

