/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import javax.annotation.Nonnull;

public final class InputStreamUtil {
    private static final int BUFFER_SIZE = 8192;
    private static final int MAX_ARRAY_LEN = 0x7FFFFFF7;
    private static final int TO_BYTE_ARRAY_DEQUE_SIZE = 20;

    public static byte[] toByteArray(InputStream in2) throws IOException {
        int initialBufferSize;
        int totalLen = 0;
        ArrayDeque<byte[]> bufs = new ArrayDeque<byte[]>(20);
        int bufSize = initialBufferSize = Math.min(8192, Math.max(128, Integer.highestOneBit(totalLen) * 2));
        while (totalLen < 0x7FFFFFF7) {
            byte[] buf = new byte[Math.min(bufSize, 0x7FFFFFF7 - totalLen)];
            bufs.add(buf);
            int off = 0;
            while (off < buf.length) {
                int r11 = in2.read(buf, off, buf.length - off);
                if (r11 == -1) {
                    return InputStreamUtil.combineBuffers(bufs, totalLen);
                }
                off += r11;
                totalLen += r11;
            }
            bufSize = InputStreamUtil.saturatedMultiply(bufSize, bufSize < 4096 ? 4 : 2);
        }
        if (in2.read() == -1) {
            return InputStreamUtil.combineBuffers(bufs, 0x7FFFFFF7);
        }
        throw new OutOfMemoryError("input is too large to fit in a byte array");
    }

    private static int saturatedMultiply(int a11, int b11) {
        long value = (long)a11 * (long)b11;
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    private static byte[] combineBuffers(Queue<byte[]> bufs, int totalLen) {
        if (bufs.isEmpty()) {
            return new byte[0];
        }
        byte[] result = bufs.remove();
        if (result.length == totalLen) {
            return result;
        }
        int remaining = totalLen - result.length;
        result = Arrays.copyOf(result, totalLen);
        while (remaining > 0) {
            byte[] buf = bufs.remove();
            int bytesToCopy = Math.min(remaining, buf.length);
            int resultOffset = totalLen - remaining;
            System.arraycopy(buf, 0, result, resultOffset, bytesToCopy);
            remaining -= bytesToCopy;
        }
        return result;
    }

    public static void skipFully(InputStream in2, long n11) throws IOException {
        long skipped = InputStreamUtil.skipUpTo(in2, n11);
        if (skipped < n11) {
            throw new EOFException("reached end of stream after skipping " + skipped + " bytes; " + n11 + " bytes expected");
        }
    }

    static long skipUpTo(InputStream in2, long n11) throws IOException {
        long totalSkipped;
        long skipped;
        byte[] buf = null;
        for (totalSkipped = 0L; totalSkipped < n11; totalSkipped += skipped) {
            long remaining = n11 - totalSkipped;
            skipped = InputStreamUtil.skipSafely(in2, remaining);
            if (skipped != 0L) continue;
            int skip = (int)Math.min(remaining, 8192L);
            if (buf == null) {
                buf = new byte[skip];
            }
            if ((skipped = (long)in2.read(buf, 0, skip)) == -1L) break;
        }
        return totalSkipped;
    }

    private static long skipSafely(InputStream in2, long n11) throws IOException {
        int available = in2.available();
        return available == 0 ? 0L : in2.skip(Math.min((long)available, n11));
    }

    public static void readFully(@Nonnull InputStream in2, @Nonnull byte[] b11) throws IOException {
        int read = InputStreamUtil.read(in2, b11, 0, b11.length);
        if (read != b11.length) {
            throw new EOFException("reached end of stream after reading " + read + " bytes; " + b11.length + " bytes expected");
        }
    }

    public static int read(@Nonnull InputStream in2, @Nonnull byte[] b11, int off, int len) throws IOException {
        int total;
        int result;
        if (off < 0 || len < 0 || off + len > b11.length) {
            throw new IndexOutOfBoundsException("trying to read invalid offset/length range");
        }
        for (total = 0; total < len && (result = in2.read(b11, off + total, len - total)) != -1; total += result) {
        }
        return total;
    }

    public static long copy(InputStream from, OutputStream to2) throws IOException {
        int r11;
        if (from == null || to2 == null) {
            throw new NullPointerException();
        }
        byte[] buf = new byte[8192];
        long total = 0L;
        while ((r11 = from.read(buf)) != -1) {
            to2.write(buf, 0, r11);
            total += (long)r11;
        }
        return total;
    }
}

