/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.annotation.Nonnull;

public class RandomAccessFileOutputStream
extends OutputStream {
    private int filePosition;
    @Nonnull
    private final RandomAccessFile raf;

    public RandomAccessFileOutputStream(@Nonnull RandomAccessFile raf, int startFilePosition) {
        this.filePosition = startFilePosition;
        this.raf = raf;
    }

    @Override
    public void write(int b11) throws IOException {
        this.raf.seek(this.filePosition);
        ++this.filePosition;
        this.raf.write(b11);
    }

    @Override
    public void write(byte[] b11) throws IOException {
        this.raf.seek(this.filePosition);
        this.filePosition += b11.length;
        this.raf.write(b11);
    }

    @Override
    public void write(byte[] b11, int off, int len) throws IOException {
        this.raf.seek(this.filePosition);
        this.filePosition += len;
        this.raf.write(b11, off, len);
    }
}

