/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import java.io.PrintStream;
import java.text.BreakIterator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringWrapper {
    public static Iterable<String> wrapStringOnBreaks(final @Nonnull String string, final int maxWidth) {
        final BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(string);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int currentLineStart = 0;
                    private boolean nextLineSet = false;
                    private String nextLine;

                    @Override
                    public boolean hasNext() {
                        if (!this.nextLineSet) {
                            this.calculateNext();
                        }
                        return this.nextLine != null;
                    }

                    private void calculateNext() {
                        int lineEnd;
                        block5: {
                            lineEnd = this.currentLineStart;
                            do {
                                if ((lineEnd = breakIterator.following(lineEnd)) == -1) {
                                    lineEnd = breakIterator.last();
                                    if (lineEnd <= this.currentLineStart) {
                                        this.nextLine = null;
                                        this.nextLineSet = true;
                                        return;
                                    }
                                } else {
                                    if (lineEnd - this.currentLineStart <= maxWidth) continue;
                                    if ((lineEnd = breakIterator.preceding(lineEnd)) <= this.currentLineStart) {
                                        lineEnd = this.currentLineStart + maxWidth;
                                    }
                                }
                                break block5;
                            } while (string.charAt(lineEnd - 1) != '\n');
                            this.nextLine = string.substring(this.currentLineStart, lineEnd - 1);
                            this.nextLineSet = true;
                            this.currentLineStart = lineEnd;
                            return;
                        }
                        this.nextLine = string.substring(this.currentLineStart, lineEnd);
                        this.nextLineSet = true;
                        this.currentLineStart = lineEnd;
                    }

                    @Override
                    public String next() {
                        String ret = this.nextLine;
                        this.nextLine = null;
                        this.nextLineSet = false;
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static String[] wrapString(@Nonnull String str, int maxWidth, @Nullable String[] output) {
        int i11;
        if (output == null) {
            output = new String[(int)((double)(str.length() / maxWidth) * 1.5 + 1.0)];
        }
        int lineStart = 0;
        int arrayIndex = 0;
        for (i11 = 0; i11 < str.length(); ++i11) {
            char c11 = str.charAt(i11);
            if (c11 == '\n') {
                output = StringWrapper.addString(output, str.substring(lineStart, i11), arrayIndex++);
                lineStart = i11 + 1;
                continue;
            }
            if (i11 - lineStart != maxWidth) continue;
            output = StringWrapper.addString(output, str.substring(lineStart, i11), arrayIndex++);
            lineStart = i11;
        }
        if (lineStart != i11 || i11 == 0) {
            output = StringWrapper.addString(output, str.substring(lineStart), arrayIndex++, output.length + 1);
        }
        if (arrayIndex < output.length) {
            output[arrayIndex] = null;
        }
        return output;
    }

    private static String[] addString(@Nonnull String[] arr, String str, int index) {
        if (index >= arr.length) {
            arr = StringWrapper.enlargeArray(arr, (int)Math.ceil((double)(arr.length + 1) * 1.5));
        }
        arr[index] = str;
        return arr;
    }

    private static String[] addString(@Nonnull String[] arr, String str, int index, int newLength) {
        if (index >= arr.length) {
            arr = StringWrapper.enlargeArray(arr, newLength);
        }
        arr[index] = str;
        return arr;
    }

    private static String[] enlargeArray(String[] arr, int newLength) {
        String[] newArr = new String[newLength];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        return newArr;
    }

    public static void printWrappedString(@Nonnull PrintStream stream, @Nonnull String string, int maxWidth) {
        for (String str : StringWrapper.wrapStringOnBreaks(string, maxWidth)) {
            stream.println(str);
        }
    }
}

