/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import com.android.tools.smali.util.StringWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.annotation.Nonnull;

public final class TwoColumnOutput {
    private final Writer out;
    private final int leftWidth;
    private final int rightWidth;
    private final String spacer;
    private String[] leftLines = null;
    private String[] rightLines = null;

    public TwoColumnOutput(@Nonnull Writer out, int leftWidth, int rightWidth, @Nonnull String spacer) {
        if (leftWidth < 1) {
            throw new IllegalArgumentException("leftWidth < 1");
        }
        if (rightWidth < 1) {
            throw new IllegalArgumentException("rightWidth < 1");
        }
        this.out = out;
        this.leftWidth = leftWidth;
        this.rightWidth = rightWidth;
        this.spacer = spacer;
    }

    public TwoColumnOutput(OutputStream out, int leftWidth, int rightWidth, String spacer) {
        this(new OutputStreamWriter(out), leftWidth, rightWidth, spacer);
    }

    public void write(String left, String right) throws IOException {
        this.leftLines = StringWrapper.wrapString(left, this.leftWidth, this.leftLines);
        this.rightLines = StringWrapper.wrapString(right, this.rightWidth, this.rightLines);
        int leftCount = this.leftLines.length;
        int rightCount = this.rightLines.length;
        for (int i11 = 0; i11 < leftCount || i11 < rightCount; ++i11) {
            int remaining;
            String leftLine = null;
            String rightLine = null;
            if (i11 < leftCount && (leftLine = this.leftLines[i11]) == null) {
                leftCount = i11;
            }
            if (i11 < rightCount && (rightLine = this.rightLines[i11]) == null) {
                rightCount = i11;
            }
            if (leftLine == null && rightLine == null) continue;
            int written = 0;
            if (leftLine != null) {
                this.out.write(leftLine);
                written = leftLine.length();
            }
            if ((remaining = this.leftWidth - written) > 0) {
                TwoColumnOutput.writeSpaces(this.out, remaining);
            }
            this.out.write(this.spacer);
            if (rightLine != null) {
                this.out.write(rightLine);
            }
            this.out.write(10);
        }
    }

    private static void writeSpaces(Writer out, int amt) throws IOException {
        while (amt > 0) {
            out.write(32);
            --amt;
        }
    }
}

