/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import com.android.tools.smali.util.Hex;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Utf8Utils {
    private static final ThreadLocal<char[]> localBuffer = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[256];
        }
    };

    public static byte[] stringToUtf8Bytes(String string) {
        int len = string.length();
        byte[] bytes = new byte[len * 3];
        int outAt = 0;
        for (int i11 = 0; i11 < len; ++i11) {
            char c11 = string.charAt(i11);
            if (c11 != '\u0000' && c11 < '\u0080') {
                bytes[outAt] = (byte)c11;
                ++outAt;
                continue;
            }
            if (c11 < '\u0800') {
                bytes[outAt] = (byte)(c11 >> 6 & 0x1F | 0xC0);
                bytes[outAt + 1] = (byte)(c11 & 0x3F | 0x80);
                outAt += 2;
                continue;
            }
            bytes[outAt] = (byte)(c11 >> 12 & 0xF | 0xE0);
            bytes[outAt + 1] = (byte)(c11 >> 6 & 0x3F | 0x80);
            bytes[outAt + 2] = (byte)(c11 & 0x3F | 0x80);
            outAt += 3;
        }
        byte[] result = new byte[outAt];
        System.arraycopy(bytes, 0, result, 0, outAt);
        return result;
    }

    public static String utf8BytesToString(byte[] bytes, int start, int length) {
        char[] chars = localBuffer.get();
        if (chars == null || chars.length < length) {
            chars = new char[length];
            localBuffer.set(chars);
        }
        int outAt = 0;
        int at2 = start;
        while (length > 0) {
            char out;
            int v02 = bytes[at2] & 0xFF;
            switch (v02 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    --length;
                    if (v02 == 0) {
                        return Utf8Utils.throwBadUtf8(v02, at2);
                    }
                    out = (char)v02;
                    ++at2;
                    break;
                }
                case 12: 
                case 13: {
                    if ((length -= 2) < 0) {
                        return Utf8Utils.throwBadUtf8(v02, at2);
                    }
                    int v12 = bytes[at2 + 1] & 0xFF;
                    if ((v12 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v12, at2 + 1);
                    }
                    int value = (v02 & 0x1F) << 6 | v12 & 0x3F;
                    if (value != 0 && value < 128) {
                        return Utf8Utils.throwBadUtf8(v12, at2 + 1);
                    }
                    out = (char)value;
                    at2 += 2;
                    break;
                }
                case 14: {
                    if ((length -= 3) < 0) {
                        return Utf8Utils.throwBadUtf8(v02, at2);
                    }
                    int v12 = bytes[at2 + 1] & 0xFF;
                    if ((v12 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v12, at2 + 1);
                    }
                    int v22 = bytes[at2 + 2] & 0xFF;
                    if ((v22 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v22, at2 + 2);
                    }
                    int value = (v02 & 0xF) << 12 | (v12 & 0x3F) << 6 | v22 & 0x3F;
                    if (value < 2048) {
                        return Utf8Utils.throwBadUtf8(v22, at2 + 2);
                    }
                    out = (char)value;
                    at2 += 3;
                    break;
                }
                default: {
                    return Utf8Utils.throwBadUtf8(v02, at2);
                }
            }
            chars[outAt] = out;
            ++outAt;
        }
        return new String(chars, 0, outAt);
    }

    public static String utf8BytesWithUtf16LengthToString(@Nonnull byte[] bytes, int start, int utf16Length) {
        return Utf8Utils.utf8BytesWithUtf16LengthToString(bytes, start, utf16Length, null);
    }

    public static String utf8BytesWithUtf16LengthToString(@Nonnull byte[] bytes, int start, int utf16Length, @Nullable int[] readLength) {
        char[] chars = localBuffer.get();
        if (chars == null || chars.length < utf16Length) {
            chars = new char[utf16Length];
            localBuffer.set(chars);
        }
        int outAt = 0;
        int at2 = 0;
        at2 = start;
        while (utf16Length > 0) {
            char out;
            int v02 = bytes[at2] & 0xFF;
            switch (v02 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (v02 == 0) {
                        return Utf8Utils.throwBadUtf8(v02, at2);
                    }
                    out = (char)v02;
                    ++at2;
                    break;
                }
                case 12: 
                case 13: {
                    int v12 = bytes[at2 + 1] & 0xFF;
                    if ((v12 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v12, at2 + 1);
                    }
                    int value = (v02 & 0x1F) << 6 | v12 & 0x3F;
                    if (value != 0 && value < 128) {
                        return Utf8Utils.throwBadUtf8(v12, at2 + 1);
                    }
                    out = (char)value;
                    at2 += 2;
                    break;
                }
                case 14: {
                    int v12 = bytes[at2 + 1] & 0xFF;
                    if ((v12 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v12, at2 + 1);
                    }
                    int v22 = bytes[at2 + 2] & 0xFF;
                    if ((v22 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(v22, at2 + 2);
                    }
                    int value = (v02 & 0xF) << 12 | (v12 & 0x3F) << 6 | v22 & 0x3F;
                    if (value < 2048) {
                        return Utf8Utils.throwBadUtf8(v22, at2 + 2);
                    }
                    out = (char)value;
                    at2 += 3;
                    break;
                }
                default: {
                    return Utf8Utils.throwBadUtf8(v02, at2);
                }
            }
            chars[outAt] = out;
            ++outAt;
            --utf16Length;
        }
        if (readLength != null && readLength.length > 0) {
            readLength[0] = at2 - start;
            readLength[0] = at2 - start;
        }
        return new String(chars, 0, outAt);
    }

    private static String throwBadUtf8(int value, int offset) {
        throw new IllegalArgumentException("bad utf-8 byte " + Hex.u1(value) + " at offset " + Hex.u4(offset));
    }
}

