/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.InlineMe;
import com.google.errorprone.annotations.InlineMeValidationDisabled;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(@CheckForNull String string) {
        return Platform.nullToEmpty(string);
    }

    @CheckForNull
    public static String emptyToNull(@CheckForNull String string) {
        return Platform.emptyToNull(string);
    }

    public static boolean isNullOrEmpty(@CheckForNull String string) {
        return Platform.stringIsNullOrEmpty(string);
    }

    public static String padStart(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb2 = new StringBuilder(minLength);
        for (int i11 = string.length(); i11 < minLength; ++i11) {
            sb2.append(padChar);
        }
        sb2.append(string);
        return sb2.toString();
    }

    public static String padEnd(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb2 = new StringBuilder(minLength);
        sb2.append(string);
        for (int i11 = string.length(); i11 < minLength; ++i11) {
            sb2.append(padChar);
        }
        return sb2.toString();
    }

    @InlineMe(replacement="string.repeat(count)")
    @InlineMeValidationDisabled(value="Java 11+ API only")
    public static String repeat(String string, int count) {
        int n11;
        Preconditions.checkNotNull(string);
        if (count <= 1) {
            Preconditions.checkArgument(count >= 0, "invalid count: %s", count);
            return count == 0 ? "" : string;
        }
        int len = string.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(51).append("Required array size too large: ").append(longSize).toString());
        }
        char[] array = new char[size];
        string.getChars(0, len, array, 0);
        for (n11 = len; n11 < size - n11; n11 <<= 1) {
            System.arraycopy(array, 0, array, n11, n11);
        }
        System.arraycopy(array, 0, array, n11, size - n11);
        return new String(array);
    }

    public static String commonPrefix(CharSequence a11, CharSequence b11) {
        int p11;
        Preconditions.checkNotNull(a11);
        Preconditions.checkNotNull(b11);
        int maxPrefixLength = Math.min(a11.length(), b11.length());
        for (p11 = 0; p11 < maxPrefixLength && a11.charAt(p11) == b11.charAt(p11); ++p11) {
        }
        if (Strings.validSurrogatePairAt(a11, p11 - 1) || Strings.validSurrogatePairAt(b11, p11 - 1)) {
            --p11;
        }
        return a11.subSequence(0, p11).toString();
    }

    public static String commonSuffix(CharSequence a11, CharSequence b11) {
        int s11;
        Preconditions.checkNotNull(a11);
        Preconditions.checkNotNull(b11);
        int maxSuffixLength = Math.min(a11.length(), b11.length());
        for (s11 = 0; s11 < maxSuffixLength && a11.charAt(a11.length() - s11 - 1) == b11.charAt(b11.length() - s11 - 1); ++s11) {
        }
        if (Strings.validSurrogatePairAt(a11, a11.length() - s11 - 1) || Strings.validSurrogatePairAt(b11, b11.length() - s11 - 1)) {
            --s11;
        }
        return a11.subSequence(a11.length() - s11, a11.length()).toString();
    }

    @VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence string, int index) {
        return index >= 0 && index <= string.length() - 2 && Character.isHighSurrogate(string.charAt(index)) && Character.isLowSurrogate(string.charAt(index + 1));
    }

    public static String lenientFormat(@CheckForNull String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args == null) {
            args = new Object[]{"(Object[])null"};
        } else {
            for (int i11 = 0; i11 < args.length; ++i11) {
                args[i11] = Strings.lenientToString(args[i11]);
            }
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i12 = 0;
        while (i12 < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i12++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i12 < args.length) {
            builder.append(" [");
            builder.append(args[i12++]);
            while (i12 < args.length) {
                builder.append(", ");
                builder.append(args[i12++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static String lenientToString(@CheckForNull Object o11) {
        if (o11 == null) {
            return "null";
        }
        try {
            return o11.toString();
        }
        catch (Exception e11) {
            String string = o11.getClass().getName();
            String string2 = Integer.toHexString(System.identityHashCode(o11));
            String objectToString = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append('@').append(string2).toString();
            String string3 = String.valueOf(objectToString);
            Logger.getLogger("com.google.common.base.Strings").log(Level.WARNING, string3.length() != 0 ? "Exception during lenientFormat for ".concat(string3) : new String("Exception during lenientFormat for "), e11);
            string = e11.getClass().getName();
            return new StringBuilder(9 + String.valueOf(objectToString).length() + String.valueOf(string).length()).append("<").append(objectToString).append(" threw ").append(string).append(">").toString();
        }
    }
}

