/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.ElementTypesAreNonnullByDefault;
import com.google.common.escape.Escaper;
import com.google.common.escape.Platform;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class UnicodeEscaper
extends Escaper {
    private static final int DEST_PAD = 32;

    protected UnicodeEscaper() {
    }

    @CheckForNull
    protected abstract char[] escape(int var1);

    @Override
    public String escape(String string) {
        Preconditions.checkNotNull(string);
        int end = string.length();
        int index = this.nextEscapeIndex(string, 0, end);
        return index == end ? string : this.escapeSlow(string, index);
    }

    protected int nextEscapeIndex(CharSequence csq, int start, int end) {
        int index;
        int cp2;
        for (index = start; index < end && (cp2 = UnicodeEscaper.codePointAt(csq, index, end)) >= 0 && this.escape(cp2) == null; index += Character.isSupplementaryCodePoint(cp2) ? 2 : 1) {
        }
        return index;
    }

    protected final String escapeSlow(String s11, int index) {
        int end = s11.length();
        char[] dest = Platform.charBufferFromThreadLocal();
        int destIndex = 0;
        int unescapedChunkStart = 0;
        while (index < end) {
            int cp2 = UnicodeEscaper.codePointAt(s11, index, end);
            if (cp2 < 0) {
                throw new IllegalArgumentException("Trailing high surrogate at end of input");
            }
            char[] escaped = this.escape(cp2);
            int nextIndex = index + (Character.isSupplementaryCodePoint(cp2) ? 2 : 1);
            if (escaped != null) {
                int charsSkipped = index - unescapedChunkStart;
                int sizeNeeded = destIndex + charsSkipped + escaped.length;
                if (dest.length < sizeNeeded) {
                    int destLength = sizeNeeded + (end - index) + 32;
                    dest = UnicodeEscaper.growBuffer(dest, destIndex, destLength);
                }
                if (charsSkipped > 0) {
                    s11.getChars(unescapedChunkStart, index, dest, destIndex);
                    destIndex += charsSkipped;
                }
                if (escaped.length > 0) {
                    System.arraycopy(escaped, 0, dest, destIndex, escaped.length);
                    destIndex += escaped.length;
                }
                unescapedChunkStart = nextIndex;
            }
            index = this.nextEscapeIndex(s11, nextIndex, end);
        }
        int charsSkipped = end - unescapedChunkStart;
        if (charsSkipped > 0) {
            int endIndex = destIndex + charsSkipped;
            if (dest.length < endIndex) {
                dest = UnicodeEscaper.growBuffer(dest, destIndex, endIndex);
            }
            s11.getChars(unescapedChunkStart, end, dest, destIndex);
            destIndex = endIndex;
        }
        return new String(dest, 0, destIndex);
    }

    protected static int codePointAt(CharSequence seq, int index, int end) {
        Preconditions.checkNotNull(seq);
        if (index < end) {
            char c12;
            if ((c12 = seq.charAt(index++)) < '\ud800' || c12 > '\udfff') {
                return c12;
            }
            if (c12 <= '\udbff') {
                if (index == end) {
                    return -c12;
                }
                char c22 = seq.charAt(index);
                if (Character.isLowSurrogate(c22)) {
                    return Character.toCodePoint(c12, c22);
                }
                char c11 = c22;
                int n11 = index;
                String string = String.valueOf(seq);
                throw new IllegalArgumentException(new StringBuilder(89 + String.valueOf(string).length()).append("Expected low surrogate but got char '").append(c22).append("' with value ").append((int)c11).append(" at index ").append(n11).append(" in '").append(string).append("'").toString());
            }
            char c13 = c12;
            int n12 = index - 1;
            String string = String.valueOf(seq);
            throw new IllegalArgumentException(new StringBuilder(88 + String.valueOf(string).length()).append("Unexpected low surrogate character '").append(c12).append("' with value ").append((int)c13).append(" at index ").append(n12).append(" in '").append(string).append("'").toString());
        }
        throw new IndexOutOfBoundsException("Index exceeds specified range");
    }

    private static char[] growBuffer(char[] dest, int index, int size) {
        if (size < 0) {
            throw new AssertionError((Object)"Cannot increase internal buffer any further");
        }
        char[] copy = new char[size];
        if (index > 0) {
            System.arraycopy(dest, 0, copy, 0, index);
        }
        return copy;
    }
}

