/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingStrategy;
import java.lang.reflect.Field;
import java.util.Locale;

public enum FieldNamingPolicy implements FieldNamingStrategy
{
    IDENTITY{

        @Override
        public String translateName(Field f11) {
            return f11.getName();
        }
    }
    ,
    UPPER_CAMEL_CASE{

        @Override
        public String translateName(Field f11) {
            return 2.upperCaseFirstLetter(f11.getName());
        }
    }
    ,
    UPPER_CAMEL_CASE_WITH_SPACES{

        @Override
        public String translateName(Field f11) {
            return 3.upperCaseFirstLetter(3.separateCamelCase(f11.getName(), ' '));
        }
    }
    ,
    UPPER_CASE_WITH_UNDERSCORES{

        @Override
        public String translateName(Field f11) {
            return 4.separateCamelCase(f11.getName(), '_').toUpperCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_UNDERSCORES{

        @Override
        public String translateName(Field f11) {
            return 5.separateCamelCase(f11.getName(), '_').toLowerCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_DASHES{

        @Override
        public String translateName(Field f11) {
            return 6.separateCamelCase(f11.getName(), '-').toLowerCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_DOTS{

        @Override
        public String translateName(Field f11) {
            return 7.separateCamelCase(f11.getName(), '.').toLowerCase(Locale.ENGLISH);
        }
    };


    static String separateCamelCase(String name, char separator) {
        StringBuilder translation = new StringBuilder();
        int length = name.length();
        for (int i11 = 0; i11 < length; ++i11) {
            char character = name.charAt(i11);
            if (Character.isUpperCase(character) && translation.length() != 0) {
                translation.append(separator);
            }
            translation.append(character);
        }
        return translation.toString();
    }

    static String upperCaseFirstLetter(String s11) {
        int length = s11.length();
        for (int i11 = 0; i11 < length; ++i11) {
            char c11 = s11.charAt(i11);
            if (!Character.isLetter(c11)) continue;
            if (Character.isUpperCase(c11)) {
                return s11;
            }
            char uppercased = Character.toUpperCase(c11);
            if (i11 == 0) {
                return uppercased + s11.substring(1);
            }
            return s11.substring(0, i11) + uppercased + s11.substring(i11 + 1);
        }
        return s11;
    }
}

