/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect;

import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedClassDef;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.DexFile;
import com.android.tools.smali.dexlib2.writer.io.FileDataStore;
import com.android.tools.smali.dexlib2.writer.pool.DexPool;
import com.android.zipflinger.Source;
import com.android.zipflinger.Sources;
import com.android.zipflinger.ZipArchive;
import com.android.zipflinger.ZipMap;
import com.android.zipflinger.ZipSource;
import com.nmmedit.apkprotect.ApkFolders;
import com.nmmedit.apkprotect.BuildNativeLib;
import com.nmmedit.apkprotect.andres.AxmlEdit;
import com.nmmedit.apkprotect.data.Prefs;
import com.nmmedit.apkprotect.dex2c.Dex2c;
import com.nmmedit.apkprotect.dex2c.DexConfig;
import com.nmmedit.apkprotect.dex2c.GlobalDexConfig;
import com.nmmedit.apkprotect.dex2c.converter.ClassAnalyzer;
import com.nmmedit.apkprotect.dex2c.converter.instructionrewriter.InstructionRewriter;
import com.nmmedit.apkprotect.dex2c.converter.structs.RegisterNativesUtilClassDef;
import com.nmmedit.apkprotect.dex2c.filters.ClassAndMethodFilter;
import com.nmmedit.apkprotect.util.ApkUtils;
import com.nmmedit.apkprotect.util.CmakeUtils;
import com.nmmedit.apkprotect.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class ApkProtect {
    public static final String ANDROID_MANIFEST_XML = "AndroidManifest.xml";
    public static final String ANDROID_APP_APPLICATION = "android.app.Application";
    private final ApkFolders apkFolders;
    private final InstructionRewriter instructionRewriter;
    private final ClassAndMethodFilter filter;
    private final ClassAnalyzer classAnalyzer;

    private ApkProtect(ApkFolders apkFolders, InstructionRewriter instructionRewriter, ClassAndMethodFilter filter, ClassAnalyzer classAnalyzer) {
        this.apkFolders = apkFolders;
        this.instructionRewriter = instructionRewriter;
        this.filter = filter;
        this.classAnalyzer = classAnalyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        File apkFile = this.apkFolders.getInApk();
        File zipExtractDir = this.apkFolders.getZipExtractTempDir();
        try {
            byte[] manifestBytes = ApkUtils.getFile(apkFile, ANDROID_MANIFEST_XML);
            if (manifestBytes == null) {
                throw new RuntimeException("Not is apk");
            }
            String packageName = AxmlEdit.getPackageName(manifestBytes);
            CmakeUtils.generateCSources(this.apkFolders.getDex2cSrcDir(), this.instructionRewriter);
            List<File> files = ApkProtect.getClassesFiles(apkFile, zipExtractDir);
            if (files.isEmpty()) {
                throw new RuntimeException("No classes.dex");
            }
            int minSdk = AxmlEdit.getMinSdk(manifestBytes);
            this.classAnalyzer.setMinSdk(minSdk);
            if (minSdk < 23) {
                // empty if block
            }
            for (File file : files) {
                this.classAnalyzer.loadDexFile(file);
            }
            GlobalDexConfig globalConfig = Dex2c.handleAllDex(files, this.filter, this.instructionRewriter, this.classAnalyzer, this.apkFolders.getCodeGeneratedDir());
            HashSet<String> mainDexClassTypeSet = new HashSet<String>();
            ArrayList<File> outDexFiles = ApkProtect.injectInstructionAndWriteToFile(globalConfig, mainDexClassTypeSet, 60000, this.apkFolders.getTempDexDir());
            List<String> abis = ApkProtect.getAbis(apkFile);
            Map<String, Map<File, File>> nativeLibs = BuildNativeLib.generateNativeLibs(this.apkFolders.getOutRootDir(), abis);
            File mainDex = outDexFiles.get(0);
            File newManDex = ApkProtect.internNativeUtilClassDef(mainDex, globalConfig, "nmmp");
            outDexFiles.set(0, newManDex);
            File outputApk = this.apkFolders.getOutputApk();
            if (outputApk.exists()) {
                outputApk.delete();
            }
            try (ZipArchive zipArchive = new ZipArchive(outputApk.toPath());){
                ZipMap zipMap = ZipMap.from(apkFile.toPath());
                ApkProtect.zipCopy(zipMap, zipArchive, -2);
                Source androidManifestSource = Sources.from(new ByteArrayInputStream(manifestBytes), ANDROID_MANIFEST_XML, -1);
                androidManifestSource.align(4L);
                zipArchive.add(androidManifestSource);
                for (File file : outDexFiles) {
                    Source source = Sources.from(file, file.getName(), -1);
                    source.align(4L);
                    zipArchive.add(source);
                }
                for (Map.Entry entry : nativeLibs.entrySet()) {
                    String abi = (String)entry.getKey();
                    for (File file : ((Map)entry.getValue()).values()) {
                        Source source = Sources.from(file, "lib/" + abi + "/" + file.getName(), -1);
                        source.align(4L);
                        zipArchive.add(source);
                    }
                }
            }
        }
        finally {
            FileUtils.deleteFile(zipExtractDir);
        }
    }

    private static List<String> getAbis(File apk) throws IOException {
        Pattern pattern = Pattern.compile("lib/(.*)/.*\\.so");
        HashSet<String> abis = new HashSet<String>();
        try (ZipArchive zipArchive = new ZipArchive(apk.toPath());){
            for (String entry : zipArchive.listEntries()) {
                Matcher matcher = pattern.matcher(entry);
                if (!matcher.matches()) continue;
                abis.add(matcher.group(1));
            }
        }
        abis.remove("armeabi");
        if (abis.isEmpty()) {
            ArrayList<String> abi = new ArrayList<String>();
            if (Prefs.isArm()) {
                abi.add("armeabi-v7a");
            }
            if (Prefs.isArm64()) {
                abi.add("arm64-v8a");
            }
            if (Prefs.isX86()) {
                abi.add("x86");
            }
            if (Prefs.isX64()) {
                abi.add("x86_64");
            }
            return abi;
        }
        return new ArrayList<String>(abis);
    }

    private static List<File> getClassesFiles(File apkFile, File zipExtractDir) throws IOException {
        List<File> files = ApkUtils.extractFiles(apkFile, "classes(\\d+)*\\.dex", zipExtractDir);
        files.sort((file, t12) -> {
            String numb = file.getName().replace("classes", "").replace(".dex", "");
            String numb2 = t12.getName().replace("classes", "").replace(".dex", "");
            int n11 = "".equals(numb) ? 0 : Integer.parseInt(numb);
            int n22 = "".equals(numb2) ? 0 : Integer.parseInt(numb2);
            return n11 - n22;
        });
        return files;
    }

    private static File dexWriteToFile(DexPool dexPool, int index, File dexOutDir) throws IOException {
        if (!dexOutDir.exists()) {
            dexOutDir.mkdirs();
        }
        File outDexFile = index == 0 ? new File(dexOutDir, "classes.dex") : new File(dexOutDir, String.format("classes%d.dex", index + 1));
        dexPool.writeTo(new FileDataStore(outDexFile));
        return outDexFile;
    }

    private static List<String> getApplicationClassesFromMainDex(GlobalDexConfig globalConfig, String applicationClass) throws IOException {
        ArrayList<String> mainDexClassList = new ArrayList<String>();
        String tmpType = ApkProtect.classDotNameToType(applicationClass);
        mainDexClassList.add(tmpType);
        for (DexConfig config : globalConfig.getConfigs()) {
            ClassDef classDef;
            DexBackedDexFile dexFile = DexBackedDexFile.fromInputStream(null, new BufferedInputStream(new FileInputStream(config.getShellDexFile())));
            Set<? extends DexBackedClassDef> classes = dexFile.getClasses();
            while ((classDef = ApkProtect.getClassDefFromType(classes, tmpType)) != null) {
                if (ApkProtect.classDotNameToType(ANDROID_APP_APPLICATION).equals(classDef.getSuperclass())) {
                    return mainDexClassList;
                }
                tmpType = classDef.getSuperclass();
                mainDexClassList.add(tmpType);
            }
        }
        return mainDexClassList;
    }

    private static ClassDef getClassDefFromType(Set<? extends ClassDef> classDefSet, String type) {
        for (ClassDef classDef : classDefSet) {
            if (!classDef.getType().equals(type)) continue;
            return classDef;
        }
        return null;
    }

    public static ArrayList<File> injectInstructionAndWriteToFile(GlobalDexConfig globalConfig, Set<String> mainClassSet, int maxPoolSize, File dexOutDir) throws IOException {
        ArrayList<File> dexFiles = new ArrayList<File>();
        DexPool lastDexPool = null;
        Opcodes opcodes = null;
        List<DexConfig> configs = globalConfig.getConfigs();
        for (DexConfig config : configs) {
            DexBackedDexFile dexNativeFile = DexBackedDexFile.fromInputStream(null, new BufferedInputStream(new FileInputStream(config.getShellDexFile())));
            if (lastDexPool == null) {
                opcodes = dexNativeFile.getOpcodes();
                lastDexPool = new DexPool(opcodes);
            }
            for (ClassDef classDef : dexNativeFile.getClasses()) {
                if (!mainClassSet.contains(classDef.getType())) continue;
                Dex2c.injectCallRegisterNativeInsns(config, lastDexPool, mainClassSet, maxPoolSize);
            }
        }
        for (int i11 = 0; i11 < configs.size(); ++i11) {
            int size;
            DexConfig config;
            config = configs.get(i11);
            List<DexPool> retPools = Dex2c.injectCallRegisterNativeInsns(config, lastDexPool, mainClassSet, maxPoolSize);
            if (retPools.isEmpty()) {
                throw new RuntimeException("Dex inject instruction error");
            }
            if (retPools.size() > 1) {
                for (int k11 = 0; k11 < retPools.size() - 1; ++k11) {
                    int n11 = dexFiles.size();
                    File file = ApkProtect.dexWriteToFile(retPools.get(k11), n11, dexOutDir);
                    dexFiles.add(file);
                }
                lastDexPool = retPools.get(retPools.size() - 1);
                if (i11 != configs.size() - 1) continue;
                size = dexFiles.size();
                File file = ApkProtect.dexWriteToFile(lastDexPool, size, dexOutDir);
                dexFiles.add(file);
                continue;
            }
            size = dexFiles.size();
            File file = ApkProtect.dexWriteToFile(retPools.get(0), size, dexOutDir);
            dexFiles.add(file);
            lastDexPool = new DexPool(opcodes);
        }
        return dexFiles;
    }

    public static void copyDex(@Nonnull DexFile oldDexFile, @Nonnull DexPool newDex) {
        for (ClassDef classDef : oldDexFile.getClasses()) {
            newDex.internClass(classDef);
        }
    }

    public static File internNativeUtilClassDef(@Nonnull File mainDex, @Nonnull GlobalDexConfig globalConfig, @Nonnull String libName) throws IOException {
        DexBackedDexFile mainDexFile = DexBackedDexFile.fromInputStream(null, new BufferedInputStream(new FileInputStream(mainDex)));
        DexPool newDex = new DexPool(mainDexFile.getOpcodes());
        ApkProtect.copyDex(mainDexFile, newDex);
        ArrayList<String> nativeMethodNames = new ArrayList<String>();
        for (DexConfig config : globalConfig.getConfigs()) {
            nativeMethodNames.add(config.getRegisterNativesMethodName());
        }
        newDex.internClass(new RegisterNativesUtilClassDef("L" + globalConfig.getConfigs().get(0).getRegisterNativesClassName() + ";", nativeMethodNames, libName));
        File injectLoadLib = new File(mainDex.getParent(), "injectLoadLib");
        if (!injectLoadLib.exists()) {
            injectLoadLib.mkdirs();
        }
        File newFile = new File(injectLoadLib, mainDex.getName());
        newDex.writeTo(new FileDataStore(newFile));
        return newFile;
    }

    private static void zipCopy(ZipMap zipMap, ZipArchive outArchive, int compressionLevel) throws IOException {
        Pattern regex = Pattern.compile("classes(\\d)*\\.dex|META-INF/.*\\.(RSA|DSA|EC|SF|MF)|AndroidManifest\\.xml");
        ZipSource zipSource = new ZipSource(zipMap);
        for (String entryName : zipMap.getEntries().keySet()) {
            if (regex.matcher(entryName).matches()) continue;
            zipSource.select(entryName, entryName, -2, 4L);
        }
        outArchive.add(zipSource);
    }

    private static String classDotNameToType(String classDotName) {
        return "L" + classDotName.replace('.', '/') + ";";
    }

    public static class Builder {
        private final ApkFolders apkFolders;
        private InstructionRewriter instructionRewriter;
        private ClassAndMethodFilter filter;
        private ClassAnalyzer classAnalyzer;

        public Builder(ApkFolders apkFolders) {
            this.apkFolders = apkFolders;
        }

        public Builder setInstructionRewriter(InstructionRewriter instructionRewriter) {
            this.instructionRewriter = instructionRewriter;
            return this;
        }

        public Builder setFilter(ClassAndMethodFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder setClassAnalyzer(ClassAnalyzer classAnalyzer) {
            this.classAnalyzer = classAnalyzer;
            return this;
        }

        public ApkProtect build() {
            if (this.instructionRewriter == null) {
                throw new RuntimeException("instructionRewriter == null");
            }
            if (this.classAnalyzer == null) {
                throw new RuntimeException("classAnalyzer==null");
            }
            return new ApkProtect(this.apkFolders, this.instructionRewriter, this.filter, this.classAnalyzer);
        }
    }
}

