/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect;

import com.nmmedit.apkprotect.data.Prefs;
import com.nmmedit.apkprotect.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public class BuildNativeLib {
    public static final String NMMP_NAME = "nmmp";
    public static final String VM_NAME = "nmmvm";

    public static Map<String, Map<File, File>> generateNativeLibs(@Nonnull File outDir, @Nonnull List<String> abis) throws IOException {
        String ndkHome;
        String sdkHome;
        String cmakePath = System.getenv("CMAKE_PATH");
        if (BuildNativeLib.isEmpty(cmakePath)) {
            System.err.println("No CMAKE_PATH");
            cmakePath = Prefs.cmakePath();
        }
        if (BuildNativeLib.isEmpty(sdkHome = System.getenv("ANDROID_SDK_HOME"))) {
            sdkHome = Prefs.sdkPath();
            System.err.println("No ANDROID_SDK_HOME. Default is " + sdkHome);
        }
        if (BuildNativeLib.isEmpty(ndkHome = System.getenv("ANDROID_NDK_HOME"))) {
            ndkHome = Prefs.ndkPath();
            System.err.println("No ANDROID_NDK_HOME. Default is " + ndkHome);
        }
        HashMap<String, Map<File, File>> allLibs = new HashMap<String, Map<File, File>>();
        for (String abi : abis) {
            CMakeOptions cmakeOptions = new CMakeOptions(cmakePath, sdkHome, ndkHome, 21, outDir.getAbsolutePath(), CMakeOptions.BuildType.RELEASE, abi);
            FileUtils.deleteFile(new File(cmakeOptions.getBuildPath()));
            Map<File, File> files = BuildNativeLib.build(cmakeOptions);
            allLibs.put(abi, files);
        }
        return allLibs;
    }

    private static boolean isEmpty(String s11) {
        return s11 == null || "".equals(s11);
    }

    public static Map<File, File> build(@NotNull CMakeOptions options) throws IOException {
        List<String> cmakeArguments = options.getCmakeArguments();
        BuildNativeLib.execCmd(cmakeArguments);
        BuildNativeLib.execCmd(Arrays.asList(options.getCmakeBinaryPath(), "--build", options.getBuildPath()));
        Map<File, File> soMaps = options.getSharedObjectFileMap();
        for (Map.Entry<File, File> entry : soMaps.entrySet()) {
            BuildNativeLib.execCmd(Arrays.asList(options.getStripBinaryPath(), "--strip-unneeded", "-o", entry.getValue().getAbsolutePath(), entry.getKey().getAbsolutePath()));
        }
        return soMaps;
    }

    private static void execCmd(List<String> cmds) throws IOException {
        System.out.println(cmds);
        ProcessBuilder builder = new ProcessBuilder(new String[0]).command(cmds);
        Process process = builder.start();
        BuildNativeLib.printOutput(process.getInputStream());
        BuildNativeLib.printOutput(process.getErrorStream());
        try {
            int exitStatus = process.waitFor();
            if (exitStatus != 0) {
                throw new IOException(String.format("Cmd '%s' exec failed", cmds.toString()));
            }
        }
        catch (InterruptedException e11) {
            e11.printStackTrace();
        }
    }

    private static void printOutput(InputStream inputStream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
    }

    public static class CMakeOptions {
        private final String cmakePath;
        private final String sdkHome;
        private final String ndkHome;
        private final int apiLevel;
        private final String projectHome;
        private final BuildType buildType;
        private final String abi;

        public CMakeOptions(String cmakePath, String sdkHome, String ndkHome, int apiLevel, String projectHome, BuildType buildType, String abi) {
            this.cmakePath = cmakePath;
            this.sdkHome = sdkHome;
            this.ndkHome = ndkHome;
            this.apiLevel = apiLevel;
            this.projectHome = projectHome;
            this.buildType = buildType;
            this.abi = abi;
        }

        public String getCmakePath() {
            return this.cmakePath;
        }

        public String getSdkHome() {
            return this.sdkHome;
        }

        public String getNdkHome() {
            return this.ndkHome;
        }

        public int getApiLevel() {
            return this.apiLevel;
        }

        public String getProjectHome() {
            return this.projectHome;
        }

        public BuildType getBuildType() {
            return this.buildType;
        }

        public String getAbi() {
            return this.abi;
        }

        @Nonnull
        public String getLibStripOutputDir() {
            return new File(new File(this.getProjectHome(), "obj/strip"), this.abi).getAbsolutePath();
        }

        @Nonnull
        public String getLibSymOutputDir() {
            return new File(new File(this.getProjectHome(), "obj/sym"), this.abi).getAbsolutePath();
        }

        public String getBuildPath() {
            return new File(this.getProjectHome(), String.format(".cxx/cmake/%s/%s", this.getBuildType().getBuildTypeName(), this.getAbi())).getAbsolutePath();
        }

        public String getStripBinaryPath() {
            return new File(this.getNdkHome(), Prefs.ndkToolchains() + "/" + Prefs.ndkAbi() + "/" + Prefs.ndkStrip()).getAbsolutePath();
        }

        public String getCmakeBinaryPath() {
            return new File(this.getCmakePath(), "/bin/cmake").getAbsolutePath();
        }

        public String getNinjaBinaryPath() {
            return new File(this.getCmakePath(), "/bin/ninja").getAbsolutePath();
        }

        public List<String> getCmakeArguments() {
            return Arrays.asList(this.getCmakeBinaryPath(), String.format("-H%s", new File(this.getProjectHome(), "dex2c").getAbsoluteFile()), String.format("-DCMAKE_TOOLCHAIN_FILE=%s", new File(this.getNdkHome(), "/build/cmake/android.toolchain.cmake").getAbsoluteFile()), String.format("-DCMAKE_BUILD_TYPE=%s", this.getBuildType().getBuildTypeName()), String.format("-DANDROID_ABI=%s", this.getAbi()), String.format("-DANDROID_NDK=%s", this.getNdkHome()), String.format("-DANDROID_PLATFORM=android-%d", this.getApiLevel()), String.format("-DCMAKE_ANDROID_ARCH_ABI=%s", this.getAbi()), String.format("-DCMAKE_ANDROID_NDK=%s", this.getNdkHome()), "-DCMAKE_EXPORT_COMPILE_COMMANDS=ON", String.format("-DCMAKE_LIBRARY_OUTPUT_DIRECTORY=%s", this.getLibSymOutputDir()), String.format("-DCMAKE_MAKE_PROGRAM=%s", this.getNinjaBinaryPath()), "-DCMAKE_SYSTEM_NAME=Android", String.format("-DCMAKE_SYSTEM_VERSION=%d", this.getApiLevel()), String.format("-B%s", this.getBuildPath()), "-GNinja");
        }

        @Nonnull
        public Map<File, File> getSharedObjectFileMap() {
            HashMap<File, File> map = new HashMap<File, File>();
            String libSymOutputDir = this.getLibSymOutputDir();
            File stripOutputDir = new File(this.getLibStripOutputDir());
            if (!stripOutputDir.exists()) {
                stripOutputDir.mkdirs();
            }
            String vm2 = "libnmmvm.so";
            File vmFile = new File(libSymOutputDir, "libnmmvm.so");
            if (!vmFile.exists()) {
                vmFile = new File(this.getBuildPath(), "vm/libnmmvm.so");
            }
            if (!vmFile.exists()) {
                throw new RuntimeException("Not Found so: " + vmFile.getAbsolutePath());
            }
            map.put(vmFile, new File(stripOutputDir, "libnmmvm.so"));
            String vmp = "libnmmp.so";
            File vmpFile = new File(libSymOutputDir, "libnmmp.so");
            if (!vmpFile.exists()) {
                vmpFile = new File(this.getBuildPath(), "libnmmp.so");
            }
            if (!vmpFile.exists()) {
                throw new RuntimeException("Not Found so: " + vmpFile.getAbsolutePath());
            }
            map.put(vmpFile, new File(stripOutputDir, "libnmmp.so"));
            return map;
        }

        public static enum BuildType {
            DEBUG("Debug"),
            RELEASE("Release");

            private final String buildTypeName;

            private BuildType(String buildTypeName) {
                this.buildTypeName = buildTypeName;
            }

            public String getBuildTypeName() {
                return this.buildTypeName;
            }
        }
    }
}

