/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.aab;

import java.io.File;
import javax.annotation.Nonnull;

public class AabFolders {
    @Nonnull
    private final File inAab;
    @Nonnull
    private final File outRootDir;

    public AabFolders(@Nonnull File inAab, @Nonnull File outRootDir) {
        this.inAab = inAab;
        this.outRootDir = outRootDir;
    }

    @Nonnull
    public File getInAab() {
        return this.inAab;
    }

    @Nonnull
    public File getOutRootDir() {
        return this.outRootDir;
    }

    @Nonnull
    public File getZipExtractTempDir() {
        return new File(this.outRootDir, ".apk_temp");
    }

    @Nonnull
    public File getDex2cSrcDir() {
        return new File(this.outRootDir, "dex2c");
    }

    @Nonnull
    public File getCodeGeneratedDir() {
        return new File(this.getDex2cSrcDir(), "generated");
    }

    @Nonnull
    public File getTempDexDir() {
        return new File(this.outRootDir, "dex_output");
    }

    @Nonnull
    public File getOutputAab() {
        String name = this.inAab.getName();
        int i11 = name.lastIndexOf(46);
        if (i11 != -1) {
            name = name.substring(0, i11);
        }
        return new File(this.outRootDir, name + "-protect.aab");
    }
}

