/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.aab;

import com.android.zipflinger.BytesSource;
import com.android.zipflinger.Entry;
import com.android.zipflinger.Source;
import com.android.zipflinger.Sources;
import com.android.zipflinger.ZipArchive;
import com.android.zipflinger.ZipMap;
import com.android.zipflinger.ZipSource;
import com.nmmedit.apkprotect.ApkProtect;
import com.nmmedit.apkprotect.BuildNativeLib;
import com.nmmedit.apkprotect.aab.AabFolders;
import com.nmmedit.apkprotect.aab.proto.ProtoUtils;
import com.nmmedit.apkprotect.dex2c.Dex2c;
import com.nmmedit.apkprotect.dex2c.GlobalDexConfig;
import com.nmmedit.apkprotect.dex2c.converter.ClassAnalyzer;
import com.nmmedit.apkprotect.dex2c.converter.instructionrewriter.InstructionRewriter;
import com.nmmedit.apkprotect.dex2c.filters.ClassAndMethodFilter;
import com.nmmedit.apkprotect.util.ApkUtils;
import com.nmmedit.apkprotect.util.CmakeUtils;
import com.nmmedit.apkprotect.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class AabProtect {
    public static final String ANDROID_MANIFEST_XML = "base/manifest/AndroidManifest.xml";
    public static final String BUNDLE_DEBUG_SYMBOL = "BUNDLE-METADATA/com.android.tools.build.debugsymbols/";
    public static final String BUNDLE_MAPPING = "BUNDLE-METADATA/com.android.tools.build.obfuscation/proguard.map";
    public static final String BUNDLE_CONFIG = "BundleConfig.pb";
    public static final String NATIVE_PB = "base/native.pb";
    @Nonnull
    private final AabFolders aabFolders;
    @Nonnull
    private final InstructionRewriter instructionRewriter;
    private final ClassAnalyzer classAnalyzer;
    private final ClassAndMethodFilter filter;

    public AabProtect(@Nonnull AabFolders aabFolders, @Nonnull InstructionRewriter instructionRewriter, @Nonnull ClassAnalyzer classAnalyzer, ClassAndMethodFilter filter) {
        this.aabFolders = aabFolders;
        this.instructionRewriter = instructionRewriter;
        this.classAnalyzer = classAnalyzer;
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        File inAab = this.aabFolders.getInAab();
        File zipExtractDir = this.aabFolders.getZipExtractTempDir();
        try {
            byte[] manifestBytes = ApkUtils.getFile(inAab, ANDROID_MANIFEST_XML);
            if (manifestBytes == null) {
                throw new RuntimeException("Not is aab");
            }
            String packageName = ProtoUtils.AndroidManifest.getPackageName(manifestBytes);
            CmakeUtils.generateCSources(this.aabFolders.getDex2cSrcDir(), this.instructionRewriter);
            List<File> files = AabProtect.getClassesFiles(inAab, zipExtractDir);
            if (files.isEmpty()) {
                throw new RuntimeException("No classes.dex");
            }
            for (File file : files) {
                this.classAnalyzer.loadDexFile(file);
            }
            GlobalDexConfig globalConfig = Dex2c.handleAllDex(files, this.filter, this.instructionRewriter, this.classAnalyzer, this.aabFolders.getCodeGeneratedDir());
            HashSet<String> mainDexClassTypeSet = new HashSet<String>();
            ArrayList<File> outDexFiles = new ArrayList<File>(ApkProtect.injectInstructionAndWriteToFile(globalConfig, mainDexClassTypeSet, 60000, this.aabFolders.getTempDexDir()));
            File mainDex = (File)outDexFiles.get(0);
            File newMainDex = ApkProtect.internNativeUtilClassDef(mainDex, globalConfig, "nmmp");
            outDexFiles.set(0, newMainDex);
            List<String> abis = AabProtect.getAbis(inAab);
            Map<String, Map<File, File>> nativeLibs = BuildNativeLib.generateNativeLibs(this.aabFolders.getOutRootDir(), abis);
            File outputAab = this.aabFolders.getOutputAab();
            if (outputAab.exists()) {
                outputAab.delete();
            }
            try (ZipArchive zipArchive = new ZipArchive(outputAab.toPath());){
                ZipMap zipMap = ZipMap.from(inAab.toPath());
                AabProtect.zipCopy(zipMap, zipArchive);
                byte[] configBytes = ApkUtils.getFile(inAab, BUNDLE_CONFIG);
                byte[] newConfigBytes = ProtoUtils.BundleConfig.editConfig(configBytes);
                BytesSource configSource = new BytesSource(newConfigBytes, BUNDLE_CONFIG, -1);
                zipArchive.add(configSource);
                byte[] newManifestBytes = ProtoUtils.AndroidManifest.editAndroidManifest(manifestBytes);
                BytesSource manifestSource = new BytesSource(newManifestBytes, ANDROID_MANIFEST_XML, -1);
                zipArchive.add(manifestSource);
                for (File file : outDexFiles) {
                    Source source = Sources.from(file, "base/dex/" + file.getName(), -1);
                    zipArchive.add(source);
                }
                for (Map.Entry entry : nativeLibs.entrySet()) {
                    for (Map.Entry soEntry : ((Map)entry.getValue()).entrySet()) {
                        File stripSo = (File)soEntry.getValue();
                        Source source = Sources.from(stripSo, "base/lib/" + (String)entry.getKey() + "/" + stripSo.getName(), -1);
                        zipArchive.add(source);
                        File symSo = (File)soEntry.getKey();
                        Source symSource = Sources.from(symSo, BUNDLE_DEBUG_SYMBOL + (String)entry.getKey() + "/" + symSo.getName() + ".sym", -1);
                        zipArchive.add(symSource);
                    }
                }
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ProtoUtils.NativeLibraries.writeNativePB(abis, bout);
                BytesSource bytesSource = new BytesSource(bout.toByteArray(), NATIVE_PB, -1);
                zipArchive.add(bytesSource);
            }
        }
        finally {
            FileUtils.deleteFile(zipExtractDir);
        }
    }

    @Nonnull
    private static List<File> getClassesFiles(File apkFile, File zipExtractDir) throws IOException {
        List<File> files = ApkUtils.extractFiles(apkFile, "base/dex/classes(\\d+)*\\.dex", zipExtractDir);
        files.sort((file, t12) -> {
            String numb = file.getName().replace("classes", "").replace(".dex", "");
            String numb2 = t12.getName().replace("classes", "").replace(".dex", "");
            int n11 = "".equals(numb) ? 0 : Integer.parseInt(numb);
            int n22 = "".equals(numb2) ? 0 : Integer.parseInt(numb2);
            return n11 - n22;
        });
        return files;
    }

    private static void zipCopy(ZipMap zipMap, ZipArchive outArchive) throws IOException {
        Pattern regex = Pattern.compile("base/dex/classes(\\d)*\\.dex|META-INF/.*\\.(RSA|DSA|EC|SF|MF)|base/native.pb|base/manifest/AndroidManifest.xml|BundleConfig.pb");
        ZipSource zipSource = new ZipSource(zipMap);
        for (Map.Entry<String, Entry> entryEntry : zipMap.getEntries().entrySet()) {
            String entryName = entryEntry.getKey();
            if (regex.matcher(entryName).matches()) continue;
            zipSource.select(entryName, entryName);
        }
        outArchive.add(zipSource);
    }

    private static List<String> getAbis(File aab) throws IOException {
        Pattern pattern = Pattern.compile("base/lib/(.*)/.*\\.so");
        HashSet<String> abis = new HashSet<String>();
        try (ZipArchive zipArchive = new ZipArchive(aab.toPath());){
            for (String entry : zipArchive.listEntries()) {
                Matcher matcher = pattern.matcher(entry);
                if (!matcher.matches()) continue;
                abis.add(matcher.group(1));
            }
        }
        abis.remove("armeabi");
        abis.remove("mips");
        abis.remove("mips64");
        if (abis.isEmpty()) {
            return Arrays.asList("armeabi-v7a", "arm64-v8a", "x86", "x86_64");
        }
        return new ArrayList<String>(abis);
    }

    public static InputStream getAabProguardMapping(File aab) throws IOException {
        ZipArchive zipArchive = new ZipArchive(aab.toPath());
        return zipArchive.getInputStream(BUNDLE_MAPPING);
    }

    public static class Builder {
        private final AabFolders aabFolders;
        private InstructionRewriter instructionRewriter;
        private ClassAnalyzer classAnalyzer;
        private ClassAndMethodFilter filter;

        public Builder(AabFolders aabFolders) {
            this.aabFolders = aabFolders;
        }

        public Builder setInstructionRewriter(InstructionRewriter instructionRewriter) {
            this.instructionRewriter = instructionRewriter;
            return this;
        }

        public Builder setFilter(ClassAndMethodFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder setClassAnalyzer(ClassAnalyzer classAnalyzer) {
            this.classAnalyzer = classAnalyzer;
            return this;
        }

        public AabProtect build() {
            if (this.instructionRewriter == null) {
                throw new RuntimeException("instructionRewriter == null");
            }
            if (this.classAnalyzer == null) {
                throw new RuntimeException("classAnalyzer == null");
            }
            return new AabProtect(this.aabFolders, this.instructionRewriter, this.classAnalyzer, this.filter);
        }
    }
}

