/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.aab.proto;

import com.android.aapt.Resources;
import com.android.bundle.Config;
import com.android.bundle.Files;
import com.android.bundle.Targeting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;

public class ProtoUtils {

    public static class NativeLibraries {
        private static Files.NativeLibraries genNativeLibsProtoBuf(@Nonnull List<String> abis) {
            Files.NativeLibraries.Builder nativeLibsBuilder = Files.NativeLibraries.newBuilder();
            for (String abi : abis) {
                Targeting.NativeDirectoryTargeting.Builder targetingBuilder = Targeting.NativeDirectoryTargeting.newBuilder();
                Files.TargetedNativeDirectory.Builder dirBuilder = Files.TargetedNativeDirectory.newBuilder();
                if ("armeabi-v7a".equals(abi)) {
                    targetingBuilder.getAbiBuilder().setAlias(Targeting.Abi.AbiAlias.ARMEABI_V7A);
                } else if ("arm64-v8a".equals(abi)) {
                    targetingBuilder.getAbiBuilder().setAlias(Targeting.Abi.AbiAlias.ARM64_V8A);
                } else if ("x86".equals(abi)) {
                    targetingBuilder.getAbiBuilder().setAlias(Targeting.Abi.AbiAlias.X86);
                } else if ("x86_64".equals(abi)) {
                    targetingBuilder.getAbiBuilder().setAlias(Targeting.Abi.AbiAlias.X86_64);
                } else {
                    throw new RuntimeException("Unknown abi " + abi);
                }
                dirBuilder.setPath("lib/" + abi);
                dirBuilder.setTargeting(targetingBuilder);
                nativeLibsBuilder.addDirectory(dirBuilder);
            }
            return nativeLibsBuilder.build();
        }

        public static void writeNativePB(@Nonnull List<String> abis, @Nonnull OutputStream out) throws IOException {
            Files.NativeLibraries nativeLibraries = NativeLibraries.genNativeLibsProtoBuf(abis);
            nativeLibraries.writeTo(out);
        }
    }

    public static class AndroidManifest {
        @Nonnull
        public static String getPackageName(@Nonnull byte[] manifestBytes) throws IOException {
            Resources.XmlNode xmlNode = Resources.XmlNode.parseFrom(manifestBytes);
            Resources.XmlElement element = xmlNode.getElement();
            if (!"manifest".equals(element.getName())) {
                throw new IOException("Not is manifest");
            }
            int count = element.getAttributeCount();
            for (int i11 = 0; i11 < count; ++i11) {
                Resources.XmlAttribute attr = element.getAttribute(i11);
                if (!"package".equals(attr.getName())) continue;
                return attr.getValue();
            }
            throw new IOException("No package attr");
        }

        @Nonnull
        public static byte[] editAndroidManifest(@Nonnull byte[] manifestBytes) throws IOException {
            Resources.XmlNode.Builder rootNodeBuilder = Resources.XmlNode.parseFrom(manifestBytes).toBuilder();
            Resources.XmlElement.Builder elementBuilder = rootNodeBuilder.getElementBuilder();
            if (!"manifest".equals(elementBuilder.getName())) {
                throw new IOException("Not is manifest");
            }
            int count = elementBuilder.getChildCount();
            for (int i11 = 0; i11 < count; ++i11) {
                Resources.XmlElement.Builder childElementBuilder;
                Resources.XmlNode.Builder childBuilder = elementBuilder.getChildBuilder(i11);
                if (!childBuilder.hasElement() || !"application".equals((childElementBuilder = childBuilder.getElementBuilder()).getName())) continue;
                int attrCount = childElementBuilder.getAttributeCount();
                int attrIdx = -1;
                for (int j11 = 0; j11 < attrCount; ++j11) {
                    Resources.XmlAttribute.Builder attribute = childElementBuilder.getAttributeBuilder(j11);
                    if (!"extractNativeLibs".equals(attribute.getName())) continue;
                    attrIdx = j11;
                }
                if (attrIdx == -1) continue;
                childElementBuilder.removeAttribute(attrIdx);
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream(manifestBytes.length);
            rootNodeBuilder.build().writeTo(bout);
            return bout.toByteArray();
        }
    }

    public static class BundleConfig {
        @Nonnull
        public static byte[] editConfig(byte[] configBytes) throws IOException {
            Config.BundleConfig.Builder configBuilder = Config.BundleConfig.parseFrom(configBytes).toBuilder();
            Config.Optimizations.Builder optimizationsBuilder = configBuilder.getOptimizationsBuilder();
            Config.UncompressNativeLibraries.Builder uncompressNativeLibBuilder = Config.UncompressNativeLibraries.newBuilder();
            uncompressNativeLibBuilder.setEnabled(false);
            optimizationsBuilder.setUncompressNativeLibraries(uncompressNativeLibBuilder);
            ByteArrayOutputStream bout = new ByteArrayOutputStream(configBytes.length);
            configBuilder.build().writeTo(bout);
            return bout.toByteArray();
        }
    }
}

