/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.aar;

import com.nmmedit.apkprotect.ApkFolders;
import java.io.File;

public class AarFolders {
    private final File aar;
    private final File out;
    public final ApkFolders apkFolders;

    public AarFolders(File aar, File out) {
        this.aar = aar;
        this.out = out;
        this.apkFolders = new ApkFolders(this.getConvertedDexJar(), out);
    }

    public File getAar() {
        return this.aar;
    }

    public File getConvertedDexJar() {
        return new File(this.getTempDir(), this.aar.getName() + "-dex.jar");
    }

    public File getTempDir() {
        File file = new File(this.out, ".dx_temp");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public File getOutputAar() {
        String name = this.aar.getName();
        int i11 = name.lastIndexOf(46);
        if (i11 != -1) {
            name = name.substring(0, i11);
        }
        return new File(this.out, name + "-protect.aar");
    }
}

