/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.aar;

import com.android.tools.r8.D8;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.zipflinger.BytesSource;
import com.android.zipflinger.Entry;
import com.android.zipflinger.Source;
import com.android.zipflinger.Sources;
import com.android.zipflinger.ZipArchive;
import com.android.zipflinger.ZipMap;
import com.android.zipflinger.ZipRepo;
import com.android.zipflinger.ZipSource;
import com.google.common.collect.HashMultimap;
import com.nmmedit.apkprotect.BuildNativeLib;
import com.nmmedit.apkprotect.aar.AarFolders;
import com.nmmedit.apkprotect.aar.asm.AsmMethod;
import com.nmmedit.apkprotect.aar.asm.AsmUtils;
import com.nmmedit.apkprotect.aar.asm.InjectStaticBlockVisitor;
import com.nmmedit.apkprotect.aar.asm.MethodToNativeVisitor;
import com.nmmedit.apkprotect.dex2c.Dex2c;
import com.nmmedit.apkprotect.dex2c.DexConfig;
import com.nmmedit.apkprotect.dex2c.converter.ClassAnalyzer;
import com.nmmedit.apkprotect.dex2c.converter.MyMethodUtil;
import com.nmmedit.apkprotect.dex2c.converter.instructionrewriter.InstructionRewriter;
import com.nmmedit.apkprotect.dex2c.filters.ClassAndMethodFilter;
import com.nmmedit.apkprotect.util.CmakeUtils;
import com.nmmedit.apkprotect.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class AarProtect {
    private final AarFolders aarFolders;
    private final InstructionRewriter instructionRewriter;
    private final ClassAndMethodFilter filter;
    private final ClassAnalyzer classAnalyzer;

    private AarProtect(AarFolders aarFolders, InstructionRewriter instructionRewriter, ClassAndMethodFilter filter, ClassAnalyzer classAnalyzer) {
        this.aarFolders = aarFolders;
        this.instructionRewriter = instructionRewriter;
        this.filter = filter;
        this.classAnalyzer = classAnalyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        File aar = this.aarFolders.getAar();
        if (!aar.exists()) {
            throw new FileNotFoundException(aar.getAbsolutePath());
        }
        File dexJar = this.classesJarToDexJar();
        File zipExtractTempDir = this.aarFolders.apkFolders.getZipExtractTempDir();
        try {
            File classesDex = AarProtect.getClassesDex(dexJar, zipExtractTempDir);
            CmakeUtils.generateCSources(this.aarFolders.apkFolders.getDex2cSrcDir(), this.instructionRewriter);
            this.classAnalyzer.loadDexFile(classesDex);
            DexConfig dexConfig = Dex2c.handleModuleDex(classesDex, this.filter, this.classAnalyzer, this.instructionRewriter, this.aarFolders.apkFolders.getCodeGeneratedDir());
            File newClassesJar = this.modifyClassFiles(dexConfig);
            Map<String, Map<File, File>> nativeLibs = BuildNativeLib.generateNativeLibs(this.aarFolders.apkFolders.getOutRootDir(), AarProtect.getAbis());
            ZipMap zipMap = ZipMap.from(aar.toPath());
            ZipSource zipSource = new ZipSource(zipMap);
            File outputAarFile = this.aarFolders.getOutputAar();
            if (outputAarFile.exists()) {
                FileUtils.deleteFile(outputAarFile);
            }
            try (ZipArchive outAar = new ZipArchive(outputAarFile.toPath());){
                for (Map.Entry<String, Entry> entry : zipMap.getEntries().entrySet()) {
                    Entry v11;
                    String name = entry.getKey();
                    if ("classes.jar".equals(name) || (v11 = entry.getValue()).isDirectory()) continue;
                    zipSource.select(name, name);
                }
                outAar.add(zipSource);
                outAar.add(Sources.from(newClassesJar, "classes.jar", -1));
                for (Map.Entry<String, Object> entry : nativeLibs.entrySet()) {
                    String abi = entry.getKey();
                    for (File file : ((Map)entry.getValue()).values()) {
                        Source source = Sources.from(file, "jni/" + abi + "/" + file.getName(), -1);
                        outAar.add(source);
                    }
                    outAar.add(Sources.dir(abi + "/"));
                }
            }
        }
        finally {
            FileUtils.deleteFile(dexJar);
            FileUtils.deleteFile(zipExtractTempDir);
        }
    }

    private File modifyClassFiles(DexConfig dexConfig) throws IOException {
        HashMultimap<String, List<? extends Method>> modifiedMethods = dexConfig.getShellMethods();
        File classJar = this.extractClassJar();
        ZipMap zipMap = ZipMap.from(classJar.toPath());
        ZipSource zipSource = new ZipSource(zipMap);
        File outClassJar = this.getOutClassJar();
        if (outClassJar.exists()) {
            FileUtils.deleteFile(outClassJar);
        }
        try (ZipRepo inZip = new ZipRepo(zipMap);
             ZipArchive outZip = new ZipArchive(outClassJar.toPath());){
            for (Map.Entry<String, Entry> entry : inZip.getEntries().entrySet()) {
                String type;
                if (entry.getValue().isDirectory()) continue;
                String name = entry.getKey();
                if (name.endsWith(".class") && modifiedMethods.containsKey(type = "L" + name.substring(0, name.length() - ".class".length()) + ";")) {
                    InputStream inClass = inZip.getInputStream(name);
                    Set methods = modifiedMethods.get((Object)type);
                    int classIdx = dexConfig.getOffsetFromClassName(type.substring(1, type.length() - 1));
                    byte[] newClassBytes = AarProtect.modifyClass(inClass, methods, dexConfig.getRegisterNativesClassName(), dexConfig.getRegisterNativesMethodName(), classIdx);
                    outZip.add(new BytesSource(newClassBytes, name, -1));
                    continue;
                }
                zipSource.select(name, name);
            }
            outZip.add(zipSource);
            byte[] bytes = AsmUtils.genCfNativeUtil(dexConfig.getRegisterNativesClassName(), "nmmp", Collections.singletonList(dexConfig.getRegisterNativesMethodName()));
            outZip.add(new BytesSource(bytes, dexConfig.getRegisterNativesClassName() + ".class", -1));
        }
        return outClassJar;
    }

    private static byte[] modifyClass(InputStream inClass, Set<List<? extends Method>> convertedMethods, String clsName, String methodName, int classIdx) throws IOException {
        HashMap<AsmMethod, List<AsmMethod>> myMethods = new HashMap<AsmMethod, List<AsmMethod>>();
        for (List<? extends Method> methods : convertedMethods) {
            if (methods.isEmpty()) {
                throw new IllegalStateException();
            }
            Method method = methods.get(0);
            String sig = MyMethodUtil.getMethodSignature(method.getParameterTypes(), method.getReturnType());
            AsmMethod asmMethod = new AsmMethod(method.getAccessFlags(), method.getName(), sig);
            if (methods.size() == 1) {
                myMethods.put(asmMethod, Collections.singletonList(asmMethod));
                continue;
            }
            if (methods.size() != 2) continue;
            Method method1 = methods.get(1);
            String sig1 = MyMethodUtil.getMethodSignature(method1.getParameterTypes(), method1.getReturnType());
            AsmMethod asmMethod1 = new AsmMethod(method1.getAccessFlags(), method1.getName(), sig1);
            myMethods.put(asmMethod, Arrays.asList(asmMethod, asmMethod1));
        }
        ClassWriter cw2 = new ClassWriter(1);
        MethodToNativeVisitor methodToNativeVisitor = new MethodToNativeVisitor(589824, cw2, myMethods);
        InjectStaticBlockVisitor visitor = new InjectStaticBlockVisitor(589824, methodToNativeVisitor, clsName, methodName, classIdx);
        ClassReader cr2 = new ClassReader(inClass);
        cr2.accept(visitor, 0);
        return cw2.toByteArray();
    }

    private static List<String> getAbis() throws IOException {
        return Arrays.asList("armeabi-v7a", "arm64-v8a", "x86", "x86_64");
    }

    private File extractClassJar() throws IOException {
        File file = new File(this.aarFolders.getTempDir(), "classes.jar");
        if (file.exists()) {
            return file;
        }
        try (ZipArchive zipArchive = new ZipArchive(this.aarFolders.getAar().toPath());
             InputStream in2 = zipArchive.getInputStream("classes.jar");
             FileOutputStream out = new FileOutputStream(file);){
            if (in2 == null) {
                throw new IllegalStateException("No classes.jar");
            }
            FileUtils.copyStream(in2, out);
        }
        return file;
    }

    private File getOutClassJar() throws IOException {
        return new File(this.aarFolders.getTempDir(), "new_classes.jar");
    }

    private File classesJarToDexJar() throws IOException {
        File classJar = this.extractClassJar();
        File convertedDexJar = this.aarFolders.getConvertedDexJar();
        D8.main(new String[]{"--release", "--output", convertedDexJar.getAbsolutePath(), classJar.getAbsolutePath()});
        return convertedDexJar;
    }

    private static File getClassesDex(File dexJar, File zipExtractDir) throws IOException {
        if (!zipExtractDir.exists()) {
            zipExtractDir.mkdirs();
        }
        File file = new File(zipExtractDir, "classes.dex");
        try (ZipArchive zipArchive = new ZipArchive(dexJar.toPath());
             InputStream dex = zipArchive.getInputStream("classes.dex");
             FileOutputStream out = new FileOutputStream(file);){
            if (dex == null) {
                throw new IllegalStateException("No classes.dex");
            }
            FileUtils.copyStream(dex, out);
        }
        return file;
    }

    public static class Builder {
        private final AarFolders aarFolders;
        private InstructionRewriter instructionRewriter;
        private ClassAndMethodFilter filter;
        private ClassAnalyzer classAnalyzer;

        public Builder(AarFolders aarFolders) {
            this.aarFolders = aarFolders;
        }

        public Builder setInstructionRewriter(InstructionRewriter instructionRewriter) {
            this.instructionRewriter = instructionRewriter;
            return this;
        }

        public Builder setFilter(ClassAndMethodFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder setClassAnalyzer(ClassAnalyzer classAnalyzer) {
            this.classAnalyzer = classAnalyzer;
            return this;
        }

        public AarProtect build() {
            if (this.instructionRewriter == null) {
                throw new RuntimeException("instructionRewriter == null");
            }
            if (this.classAnalyzer == null) {
                throw new RuntimeException("classAnalyzer==null");
            }
            return new AarProtect(this.aarFolders, this.instructionRewriter, this.filter, this.classAnalyzer);
        }
    }
}

