/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.aar.asm;

import javax.annotation.Nonnull;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class InjectStaticBlockVisitor
extends ClassVisitor {
    private final String typeName;
    private final String methodName;
    private final int classIdx;
    private boolean hasStaticBlock;

    public InjectStaticBlockVisitor(int api, ClassVisitor classVisitor, String typeName, String methodName, int classIdx) {
        super(api, classVisitor);
        this.typeName = typeName;
        this.methodName = methodName;
        this.classIdx = classIdx;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if ("<clinit>".equals(name)) {
            this.hasStaticBlock = true;
            MethodVisitor mv2 = super.visitMethod(access, name, descriptor, signature, exceptions);
            return new MethodVisitor(this.api, mv2){

                @Override
                public void visitCode() {
                    super.visitCode();
                    InjectStaticBlockVisitor.genCallClassesInit(this, InjectStaticBlockVisitor.this.typeName, InjectStaticBlockVisitor.this.methodName, InjectStaticBlockVisitor.this.classIdx);
                }
            };
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        MethodVisitor mv2;
        super.visitEnd();
        if (!this.hasStaticBlock && this.cv != null && (mv2 = this.cv.visitMethod(9, "<clinit>", "()V", null, null)) != null) {
            mv2.visitCode();
            InjectStaticBlockVisitor.genCallClassesInit(mv2, this.typeName, this.methodName, this.classIdx);
            mv2.visitInsn(177);
            mv2.visitEnd();
        }
    }

    private static void genCallClassesInit(@Nonnull MethodVisitor mv2, String clsName, String initMethodName, int idx) {
        if (idx < 0) {
            mv2.visitLdcInsn(idx);
        } else if (idx <= 127) {
            mv2.visitIntInsn(16, idx);
        } else if (idx <= Short.MAX_VALUE) {
            mv2.visitIntInsn(17, idx);
        } else {
            mv2.visitLdcInsn(idx);
        }
        mv2.visitMethodInsn(184, clsName, initMethodName, "(I)V", false);
    }
}

