/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.andres;

import apk.arsc.Chunk;
import apk.arsc.ResourceFile;
import apk.arsc.ResourceValue;
import apk.arsc.StringPoolChunk;
import apk.arsc.XmlAttribute;
import apk.arsc.XmlChunk;
import apk.arsc.XmlStartElementChunk;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class AxmlEdit {
    @Nonnull
    public static String getApplicationName(@Nonnull byte[] manifestBytes) {
        ResourceFile file = new ResourceFile(manifestBytes);
        for (Chunk chunk : file.getChunks()) {
            if (!(chunk instanceof XmlChunk)) continue;
            XmlChunk xmlChunk = (XmlChunk)chunk;
            for (Chunk subChunk : xmlChunk.getChunks().values()) {
                XmlStartElementChunk startElementChunk;
                if (!(subChunk instanceof XmlStartElementChunk) || !(startElementChunk = (XmlStartElementChunk)subChunk).getName().equals("application")) continue;
                return AxmlEdit.getApplicationName(startElementChunk);
            }
        }
        return "";
    }

    @Nonnull
    public static int getMinSdk(@Nonnull byte[] manifestBytes) {
        ResourceFile file = new ResourceFile(manifestBytes);
        for (Chunk chunk : file.getChunks()) {
            if (!(chunk instanceof XmlChunk)) continue;
            XmlChunk xmlChunk = (XmlChunk)chunk;
            for (Chunk subChunk : xmlChunk.getChunks().values()) {
                XmlStartElementChunk startElementChunk;
                if (!(subChunk instanceof XmlStartElementChunk) || !(startElementChunk = (XmlStartElementChunk)subChunk).getName().equals("uses-sdk")) continue;
                List<XmlAttribute> attributes = startElementChunk.getAttributes();
                for (XmlAttribute attribute : attributes) {
                    ResourceValue typedValue = attribute.typedValue();
                    if (!attribute.name().equals("minSdkVersion") || typedValue.type() != ResourceValue.Type.INT_DEC) continue;
                    return attribute.typedValue().data();
                }
            }
        }
        return 21;
    }

    @Nonnull
    public static String getPackageName(@Nonnull byte[] manifestBytes) {
        ResourceFile file = new ResourceFile(manifestBytes);
        for (Chunk chunk : file.getChunks()) {
            if (!(chunk instanceof XmlChunk)) continue;
            XmlChunk xmlChunk = (XmlChunk)chunk;
            for (Chunk subChunk : xmlChunk.getChunks().values()) {
                XmlStartElementChunk startElementChunk;
                if (!(subChunk instanceof XmlStartElementChunk) || !(startElementChunk = (XmlStartElementChunk)subChunk).getName().equals("manifest")) continue;
                for (XmlAttribute attribute : startElementChunk.getAttributes()) {
                    if (!attribute.name().equals("package")) continue;
                    return attribute.rawValue();
                }
            }
        }
        return "";
    }

    public static byte[] renameApplicationName(@Nonnull byte[] manifestBytes, @Nonnull String newName) throws IOException {
        ResourceFile file = new ResourceFile(manifestBytes);
        boolean modified = false;
        block0: for (Chunk chunk : file.getChunks()) {
            if (!(chunk instanceof XmlChunk)) continue;
            XmlChunk xmlChunk = (XmlChunk)chunk;
            StringPoolChunk stringPoolChunk = AxmlEdit.getStringPoolChunk(xmlChunk);
            if (stringPoolChunk == null) {
                return null;
            }
            for (Chunk subChunk : xmlChunk.getChunks().values()) {
                XmlStartElementChunk startElementChunk;
                if (!(subChunk instanceof XmlStartElementChunk) || !AxmlEdit.modifyApplicationName(stringPoolChunk, startElementChunk = (XmlStartElementChunk)subChunk, newName)) continue;
                modified = true;
                continue block0;
            }
        }
        if (modified) {
            return file.toByteArray(1);
        }
        return null;
    }

    @Nonnull
    private static String getApplicationName(@Nonnull XmlStartElementChunk startElement) {
        List<XmlAttribute> attributes = startElement.getAttributes();
        for (XmlAttribute attribute : attributes) {
            ResourceValue typedValue = attribute.typedValue();
            if (!attribute.name().equals("name") || typedValue.type() != ResourceValue.Type.STRING) continue;
            return attribute.rawValue();
        }
        return "";
    }

    private static boolean modifyApplicationName(@Nonnull StringPoolChunk stringPoolChunk, @Nonnull XmlStartElementChunk startElement, @Nonnull String newAppName) {
        if (startElement.getName().equals("application")) {
            List<XmlAttribute> attributes = startElement.getAttributes();
            for (int i11 = 0; i11 < attributes.size(); ++i11) {
                XmlAttribute attribute = attributes.get(i11);
                ResourceValue typedValue = attribute.typedValue();
                if (!attribute.name().equals("name") || typedValue.type() != ResourceValue.Type.STRING) continue;
                XmlAttribute newAttr = AxmlEdit.createXmlNameAttribute(stringPoolChunk, startElement, newAppName);
                startElement.setAttribute(i11, newAttr);
                return true;
            }
            XmlAttribute newAttr = AxmlEdit.createXmlNameAttribute(stringPoolChunk, startElement, newAppName);
            int nameAttrIndex = 0;
            for (XmlAttribute attribute : attributes) {
                if (!"theme".equals(attribute.name()) && !"label".equals(attribute.name()) && !"icon".equals(attribute.name())) continue;
                ++nameAttrIndex;
            }
            startElement.addAttribute(nameAttrIndex, newAttr);
            return true;
        }
        return false;
    }

    private static int getOrAddString(StringPoolChunk stringPool, String str) {
        int index = stringPool.indexOf(str);
        if (index != -1) {
            return index;
        }
        return stringPool.addString(str);
    }

    @Nonnull
    private static XmlAttribute createXmlNameAttribute(@Nonnull StringPoolChunk stringPoolChunk, @Nonnull XmlStartElementChunk startElementChunk, @Nonnull String str) {
        XmlAttribute attribute;
        int strIdx = AxmlEdit.getOrAddString(stringPoolChunk, str);
        ResourceValue resourceValue = ResourceValue.builder().data(strIdx).size(8).type(ResourceValue.Type.STRING).build();
        String attrNameSpace = "";
        Iterator<XmlAttribute> iterator = startElementChunk.getAttributes().iterator();
        while (iterator.hasNext() && "".equals(attrNameSpace = (attribute = iterator.next()).namespace())) {
        }
        if ("".equals(attrNameSpace)) {
            throw new RuntimeException("Modify application name falied");
        }
        int nameSpaceIdx = AxmlEdit.getOrAddString(stringPoolChunk, attrNameSpace);
        int name = AxmlEdit.getOrAddString(stringPoolChunk, "name");
        return XmlAttribute.create(nameSpaceIdx, name, strIdx, resourceValue, startElementChunk);
    }

    private static StringPoolChunk getStringPoolChunk(XmlChunk xmlChunk) {
        for (Chunk chunk : xmlChunk.getChunks().values()) {
            if (!(chunk instanceof StringPoolChunk)) continue;
            return (StringPoolChunk)chunk;
        }
        return null;
    }
}

