/*
 * Decompiled with CFR 0.152.
 */
package com.nmmedit.apkprotect.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nmmedit.apkprotect.data.config.Config;
import com.nmmedit.apkprotect.util.FileUtils;
import com.nmmedit.apkprotect.util.OsDetector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class Prefs {
    public static final String CONFIG_PATH = new File(FileUtils.getHomePath(), "tools/" + (OsDetector.isWindows() ? "config-windows.json" : "config.json")).getAbsolutePath();

    public static Config config() {
        File configFile = new File(CONFIG_PATH);
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            try (InputStream inputStream = Prefs.class.getResourceAsStream("/" + (OsDetector.isWindows() ? "config-windows.json" : "config.json"));
                 FileOutputStream outputStream = new FileOutputStream(configFile);){
                FileUtils.copyStream(inputStream, outputStream);
            }
            catch (IOException e11) {
                e11.printStackTrace();
            }
        }
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        try {
            String content = FileUtils.readFile(CONFIG_PATH, StandardCharsets.UTF_8);
            Config config = gson.fromJson(content, Config.class);
            if (config.environment == null) {
                File file = new File(CONFIG_PATH);
                file.delete();
                return Prefs.config();
            }
            return config;
        }
        catch (IOException e12) {
            throw new RuntimeException("Load config failed", e12);
        }
    }

    public static boolean isArm() {
        return Prefs.config().abi.arm;
    }

    public static boolean isArm64() {
        return Prefs.config().abi.arm64;
    }

    public static boolean isX86() {
        return Prefs.config().abi.x86;
    }

    public static boolean isX64() {
        return Prefs.config().abi.x64;
    }

    public static String sdkPath() {
        return Prefs.config().environment.sdk_path;
    }

    public static String cmakePath() {
        return Prefs.config().environment.cmake_path;
    }

    public static String ndkPath() {
        return Prefs.config().environment.ndk_path;
    }

    public static String ndkToolchains() {
        return Prefs.config().environment.ndk_toolchains;
    }

    public static String ndkAbi() {
        return Prefs.config().environment.ndk_abi;
    }

    public static String ndkStrip() {
        return Prefs.config().environment.ndk_strip;
    }
}

